/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.crafting.ICacheRecipe;
import nmd.primal.core.api.interfaces.storage.IItemCrafting;
import nmd.primal.core.common.recipes.tile.BrickRecipe;
import nmd.primal.core.common.tiles.AbstractTileType;

public class TileBrickMold
extends AbstractTileType
implements IItemCrafting,
ICacheRecipe<BrickRecipe> {
    private ItemStackHandler craftingHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileBrickMold.this.updateBlock();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            BrickRecipe recipe = TileBrickMold.this.matchRecipe(stack);
            if (recipe != null && !recipe.getOutput().func_190926_b()) {
                ItemStack restack = recipe.getOutput().func_77946_l();
                restack.func_190920_e(stack.func_190916_E());
                super.setStackInSlot(slot, restack);
            }
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            BrickRecipe recipe = TileBrickMold.this.matchRecipe(stack);
            if (recipe != null && !recipe.getOutput().func_190926_b()) {
                ItemStack restack = recipe.getOutput().func_77946_l();
                restack.func_190920_e(stack.func_190916_E());
                return super.insertItem(slot, restack, simulate);
            }
            return stack;
        }
    };
    private List<BrickRecipe> recipe_cache = new ArrayList<BrickRecipe>();

    @Override
    public ItemStackHandler getCraftingHandler() {
        return this.craftingHandler;
    }

    @Override
    public List<BrickRecipe> getRecipeCache() {
        return this.recipe_cache;
    }

    public BrickRecipe matchRecipe(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (BrickRecipe recipe : this.getRecipeCache()) {
                if (!recipe.matches(stack)) continue;
                return recipe;
            }
            for (BrickRecipe recipe : BrickRecipe.RECIPES) {
                if (!recipe.matches(stack)) continue;
                this.addRecipeCache(recipe);
                return recipe;
            }
        }
        return null;
    }

    @Override
    public BrickRecipe matchRecipe() {
        for (BrickRecipe recipe : this.getRecipeCache()) {
            if (!recipe.matches(this)) continue;
            return recipe;
        }
        for (BrickRecipe recipe : BrickRecipe.RECIPES) {
            if (!recipe.matches(this)) continue;
            this.addRecipeCache(recipe);
            return recipe;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getCraftingHandler() != null) {
            return (T)this.getCraftingHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        this.getCraftingHandler().deserializeNBT(nbt.func_74775_l("crafting"));
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeCraftingHandler(nbt);
        return nbt;
    }
}

