/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.SmelterIngredientEvent;
import nmd.primal.core.api.events.SmelterRecipeEvent;
import nmd.primal.core.api.events.SmelterStorageEvent;
import nmd.primal.core.api.interfaces.crafting.ICacheRecipe;
import nmd.primal.core.api.interfaces.crafting.ITileRecipe;
import nmd.primal.core.common.helper.StackHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.recipes.tile.SmelterRecipe;
import nmd.primal.core.common.tiles.AbstractTilePottery;

public class TileSmelter
extends AbstractTilePottery
implements ITileRecipe<SmelterRecipe>,
ICacheRecipe<SmelterRecipe> {
    private ItemStackHandler inputHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b()) {
                MinecraftForge.EVENT_BUS.post((Event)new SmelterIngredientEvent.Post(TileSmelter.this, stack, slot));
            }
            TileSmelter.this.updateBlock();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            SmelterIngredientEvent.Pre pre = new SmelterIngredientEvent.Pre(TileSmelter.this, stack, slot);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            SmelterIngredientEvent.Pre pre;
            if (!simulate && MinecraftForge.EVENT_BUS.post((Event)(pre = new SmelterIngredientEvent.Pre(TileSmelter.this, stack, slot)))) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private ItemStackHandler outputHandler = new ItemStackHandler(8){

        protected void onContentsChanged(int slot) {
            TileSmelter.this.updateBlock();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            SmelterStorageEvent.Pre pre = new SmelterStorageEvent.Pre(TileSmelter.this, stack, slot);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return;
            }
            super.setStackInSlot(slot, stack);
            MinecraftForge.EVENT_BUS.post((Event)new SmelterStorageEvent.Post(TileSmelter.this, stack, slot));
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            SmelterStorageEvent.Pre pre;
            if (!simulate && MinecraftForge.EVENT_BUS.post((Event)(pre = new SmelterStorageEvent.Pre(TileSmelter.this, stack, slot)))) {
                return stack;
            }
            ItemStack placedStack = super.insertItem(slot, stack, simulate);
            if (!simulate) {
                MinecraftForge.EVENT_BUS.post((Event)new SmelterStorageEvent.Post(TileSmelter.this, placedStack, slot));
            }
            return placedStack;
        }
    };
    private int counter;
    private List<SmelterRecipe> recipe_cache = new ArrayList<SmelterRecipe>();

    public int getCounter() {
        return Math.max(0, this.counter);
    }

    public void resetCount() {
        this.setCounter(0);
    }

    public void setCounter(int count) {
        this.counter = Math.max(0, count);
    }

    public void reduceCounter() {
        int amount = this.RANDOM.nextInt(3);
        for (int i = 0; i <= amount; ++i) {
            if (this.counter <= 1) continue;
            --this.counter;
        }
    }

    public void setRecipeTime(SmelterRecipe recipe) {
        int recipe_time = recipe.getCookTime();
        int modified_time = Math.max(0, (int)Math.floor((double)recipe_time * ModConfig.Machines.SMELTER_TIME_MODIFIER));
        int entropy = modified_time > 3 ? this.RANDOM.nextInt((int)Math.floor((float)modified_time * 0.35f)) : 0;
        this.setCounter((modified_time > 0 ? modified_time : recipe_time) + entropy);
    }

    @Override
    public List<SmelterRecipe> getRecipeCache() {
        return this.recipe_cache;
    }

    @Override
    public SmelterRecipe matchRecipe() {
        for (SmelterRecipe recipe : this.getRecipeCache()) {
            if (!recipe.matches(this)) continue;
            PrimalAPI.logger(24, "smelter", "recipe match found from cache: " + recipe.getRegistryName());
            return recipe;
        }
        for (SmelterRecipe recipe : SmelterRecipe.RECIPES) {
            if (!recipe.matches(this)) continue;
            PrimalAPI.logger(24, "smelter", "recipe match found from registry: " + recipe.getRegistryName());
            this.addRecipeCache(recipe);
            return recipe;
        }
        return null;
    }

    @Override
    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public ItemStackHandler getStorageHandler() {
        return this.outputHandler;
    }

    @Override
    public void onTakeOutput() {
        this.playSoundTake();
    }

    @Override
    public void onAddInput() {
        this.playSoundAdd();
        this.spawnParticles();
    }

    @Override
    public boolean finishRecipe(SmelterRecipe recipe) {
        List<List<ItemStack>> inputs = recipe.getInput();
        List<ItemStack> outputs = recipe.getOutput();
        SmelterRecipeEvent.Pre pre = new SmelterRecipeEvent.Pre(this, recipe, outputs);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            return false;
        }
        ItemStackHandler input = this.getInputHandler();
        ItemStackHandler output = this.getStorageHandler();
        block0: for (List<ItemStack> recipe_list : inputs) {
            for (ItemStack recipe_stack : recipe_list) {
                for (int slot = 0; slot < input.getSlots(); ++slot) {
                    int recipe_amount;
                    ItemStack tile_stack = input.getStackInSlot(slot).func_77946_l();
                    if (!StackHelper.containsStack(tile_stack, recipe_stack) || (recipe_amount = recipe_stack.func_190916_E()) <= 0) continue;
                    if (recipe.matchCatalyst(tile_stack)) {
                        input.getStackInSlot(slot).func_96631_a(1, (Random)this.RANDOM, null);
                        continue block0;
                    }
                    if (this.consumeItem(input, slot, recipe_amount)) continue block0;
                }
            }
        }
        for (ItemStack output_item : outputs) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)output_item.func_77946_l(), (boolean)false);
        }
        this.playSoundCraft();
        this.spawnParticles();
        MinecraftForge.EVENT_BUS.post((Event)new SmelterRecipeEvent.Post(this, recipe));
        this.resetCount();
        this.updateBlock();
        return true;
    }

    public void addSlag() {
        ItemStackHandler handler = this.getOutputHandler();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!PrimalAPI.randomCheck(ModConfig.Machines.SMELTER_SLAG_CHANCE) || !handler.getStackInSlot(i).func_190926_b()) continue;
            int amount = this.RANDOM.nextInt(1, 6);
            ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)new ItemStack(this.getSlag(), amount), (boolean)false);
        }
    }

    private Item getSlag() {
        return PrimalAPI.Items.SLAG;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null && facing == EnumFacing.UP) {
                return (T)this.inputHandler;
            }
            return (T)this.getStorageHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        nbt = super.readNBT(nbt);
        nbt = this.readRecipeItemHandler(nbt, this.getInputHandler(), "crafting");
        nbt = this.readRecipeItemHandler(nbt, this.getOutputHandler(), "storage");
        this.setCounter(nbt.func_74762_e("counter"));
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = super.writeNBT(nbt);
        nbt = this.writeRecipeItemHandler(nbt, this.getInputHandler(), "crafting");
        nbt = this.writeRecipeItemHandler(nbt, this.getOutputHandler(), "storage");
        nbt.func_74768_a("counter", this.getCounter());
        return nbt;
    }
}

