/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.storage.IItemStorage;
import nmd.primal.core.common.blocks.machines.Barrel;
import nmd.primal.core.common.blocks.machines.StorageCrate;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.init.ModCompat;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.tiles.AbstractTile;

public class TileStorageCrate
extends AbstractTile
implements IItemStorage {
    private ItemStackHandler storageHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileStorageCrate.this.updateBlock();
        }
    };
    public String name;

    @Override
    public ItemStackHandler getStorageHandler() {
        return this.storageHandler;
    }

    public static boolean isValidStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (Loader.isModLoaded((String)"immersiveengineering") && block == ModCompat.IE_WOOD_DEVICE_0) {
            return false;
        }
        return !(block instanceof BlockShulkerBox) && !(block instanceof StorageCrate) && !(block instanceof Barrel);
    }

    public boolean shouldDrop() {
        return ModConfig.Machines.CRATES_RETAIN_INVENTORY;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return this.hasCustomName() ? this.name : "Storage Crate";
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getStorageHandler() != null) {
            return (T)this.getStorageHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("storage", 10)) {
            this.getStorageHandler().deserializeNBT(nbt.func_74775_l("storage"));
        } else {
            this.storageHandler = new ItemStackHandler(this.getStorageHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getStorageHandler(), "storage");
        }
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeStorageHandler(nbt, this.getStorageHandler(), "storage");
        return nbt;
    }
}

