/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.tiles.machines;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import nmd.primal.core.api.interfaces.storage.IItemStorage;
import nmd.primal.core.common.helper.NBTHelper;
import nmd.primal.core.common.tiles.AbstractTileWorkTable;

public class TileWorkTableShelf
extends AbstractTileWorkTable
implements IItemStorage {
    private ItemStackHandler storageHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileWorkTableShelf.this.updateBlock();
        }
    };

    @Override
    public ItemStackHandler getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(ItemStackHandler handler) {
        this.storageHandler = handler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            switch (facing) {
                case UP: {
                    if (this.getCraftingHandler() == null) break;
                    return (T)this.getCraftingHandler();
                }
            }
            if (this.getStorageHandler() != null) {
                return (T)this.getStorageHandler();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound readNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("crafting", 10)) {
            this.getCraftingHandler().deserializeNBT(nbt.func_74775_l("crafting"));
        } else {
            this.setCraftingHandler(new ItemStackHandler(this.getStorageHandler().getSlots()));
            NBTHelper.readNBTItems(nbt, this.getStorageHandler(), "crafting");
        }
        if (nbt.func_150297_b("storage", 10)) {
            this.getStorageHandler().deserializeNBT(nbt.func_74775_l("storage"));
        } else {
            this.storageHandler = new ItemStackHandler(this.getStorageHandler().getSlots());
            NBTHelper.readNBTItems(nbt, this.getStorageHandler(), "storage");
        }
        return nbt;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt = this.writeStorageHandler(nbt, this.getCraftingHandler(), "crafting");
        nbt = this.writeStorageHandler(nbt, this.getStorageHandler(), "storage");
        return nbt;
    }
}

