/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class PendingBlocks
extends WorldSavedData {
    private Map<ChunkPos, Map<BlockPos, IBlockState>> pendingBlocks = new HashMap<ChunkPos, Map<BlockPos, IBlockState>>();

    public PendingBlocks(String name) {
        super(name);
    }

    public void storePending(BlockPos pos, IBlockState state) {
        Map entries = this.pendingBlocks.computeIfAbsent(new ChunkPos(pos), k -> new HashMap());
        entries.put(pos.func_185334_h(), state);
        this.func_76185_a();
    }

    public void processPending(ChunkPos pos, World world, Predicate<IBlockState> predicate) {
        Map<BlockPos, IBlockState> pending = this.pendingBlocks.get(pos);
        if (pending != null && !pending.isEmpty()) {
            Iterator<Map.Entry<BlockPos, IBlockState>> iterator = pending.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, IBlockState> e = iterator.next();
                BlockPos blockPos = e.getKey();
                IBlockState state = world.func_180495_p(blockPos);
                if (state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, blockPos, predicate)) {
                    world.func_180501_a(blockPos, e.getValue(), 18);
                }
                iterator.remove();
            }
            if (pending.isEmpty()) {
                this.pendingBlocks.remove(pos);
            }
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.pendingBlocks.clear();
        for (String key : nbt.func_150296_c()) {
            NBTBase val = nbt.func_74781_a(key);
            if (!(val instanceof NBTTagList) || ((NBTTagList)val).func_150303_d() != 10 || val.func_82582_d()) continue;
            try {
                Long asLong = Long.parseLong(key);
                NBTTagList list = (NBTTagList)val;
                ChunkPos chunkPos = new ChunkPos((int)(asLong & 0xFFFFFFFFL), (int)(asLong >> 32 & 0xFFFFFFFFL));
                HashMap<BlockPos, IBlockState> entries = new HashMap<BlockPos, IBlockState>();
                for (NBTBase b : list) {
                    if (!(b instanceof NBTTagCompound) || !((NBTTagCompound)b).func_74764_b("pos") || !((NBTTagCompound)b).func_74764_b("state")) continue;
                    NBTTagCompound e = (NBTTagCompound)b;
                    entries.put(NBTUtil.func_186861_c((NBTTagCompound)e.func_74775_l("pos")), NBTUtil.func_190008_d((NBTTagCompound)e.func_74775_l("state")));
                }
                if (entries.isEmpty()) continue;
                this.pendingBlocks.put(chunkPos, entries);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        for (Map.Entry<ChunkPos, Map<BlockPos, IBlockState>> chunkEntry : this.pendingBlocks.entrySet()) {
            if (chunkEntry.getValue().isEmpty()) continue;
            NBTTagList chunkEntries = new NBTTagList();
            compound.func_74782_a(Long.toString(ChunkPos.func_77272_a((int)chunkEntry.getKey().field_77276_a, (int)chunkEntry.getKey().field_77275_b)), (NBTBase)chunkEntries);
            for (Map.Entry<BlockPos, IBlockState> blockEntry : chunkEntry.getValue().entrySet()) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockEntry.getKey()));
                entry.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)blockEntry.getValue()));
                chunkEntries.func_74742_a((NBTBase)entry);
            }
        }
        return compound;
    }

    public static PendingBlocks getForWorld(World world, String dataID) {
        PendingBlocks ret = (PendingBlocks)world.func_72943_a(PendingBlocks.class, dataID);
        if (ret == null) {
            ret = new PendingBlocks(dataID);
            world.func_72823_a(dataID, (WorldSavedData)ret);
        }
        return ret;
    }
}

