/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.SaltOre;
import nmd.primal.core.common.blocks.ores.Zinc;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenHangingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafe;
import nmd.primal.core.common.world.feature.GenStrand;

public class EndGeneral
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.THE_END && ModConfig.Worldgen.ENABLE_GENERATION_END) {
            BlockPos pos;
            int k;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            PendingBlocks.getForWorld(world, "primal.world.end_air").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_END_AIR);
            PendingBlocks.getForWorld(world, "primal.world.end_stone").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_END_STONE);
            PendingBlocks.getForWorld(world, "primal.world.end_inclusive").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_END_INCLUSIVE);
            if (ModConfig.Worldgen.ENABLE_NIGHT_STONE) {
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, 80)) {
                    for (k = 0; k < 3; ++k) {
                        pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(90, 250), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenOreSafe(PrimalAPI.Blocks.NIGHT_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(24, 60), WorldHelper.PREDICATE_END_AIR, "primal.world.end_air").func_180709_b(world, PrimalCore.RANDOM, pos) || !ModConfig.Worldgen.ENABLE_SALT_END || !PrimalAPI.randomCheck(PrimalCore.RANDOM, 2)) continue;
                        new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.VOID)), PrimalCore.RANDOM.nextInt(16, 30), WorldHelper.PREDICATE_END_INCLUSIVE, "primal.world.end_inclusive").func_180709_b(world, PrimalCore.RANDOM, pos);
                    }
                }
            } else if (ModConfig.Worldgen.ENABLE_SALT_END && PrimalAPI.randomCheck(PrimalCore.RANDOM, 70)) {
                for (k = 0; k < 1 + PrimalCore.RANDOM.nextInt(7); ++k) {
                    pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(90, 250), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.VOID)), PrimalCore.RANDOM.nextInt(16, 30), WorldHelper.PREDICATE_END_AIR, "primal.world.end_air").func_180709_b(world, PrimalCore.RANDOM, pos)) continue;
                }
            }
            if (ModConfig.Worldgen.ENABLE_ERODED_END_STONE && PrimalAPI.randomCheck(PrimalCore.RANDOM, 6)) {
                for (k = 0; k < 10; ++k) {
                    pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(16, 65), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.ERODED_END_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(6, 32), WorldHelper.PREDICATE_END_STONE, "primal.world.end_stone").func_180709_b(world, PrimalCore.RANDOM, pos)) continue;
                    PrimalAPI.logger(3, "worldgen erroded endstone", "@" + pos);
                }
            }
            if (ModConfig.Worldgen.ENABLE_PURPURITE_STONE) {
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, 160)) {
                    for (k = 0; k < 2; ++k) {
                        pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(90, 250), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenStrand(PrimalAPI.Blocks.PURPURITE_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(16, 40)).func_180709_b(world, PrimalCore.RANDOM, pos)) continue;
                    }
                }
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, 60)) {
                    for (k = 0; k < 4; ++k) {
                        pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(8, 90), z + PrimalCore.RANDOM.nextInt(8));
                        if (!new GenHangingBlocks(PrimalAPI.Blocks.PURPURITE_STONE.func_176223_P()).func_180709_b(world, PrimalCore.RANDOM, pos)) continue;
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_ZINC && PrimalAPI.randomCheck(60)) {
                for (k = 0; k < 16; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_ZINC.func_176223_P().func_177226_a(Zinc.TYPE, (Comparable)((Object)Zinc.Type.END)), PrimalCore.RANDOM.nextInt(2, 16), WorldHelper.PREDICATE_END_STONE, "primal.world.end_stone").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(24, 96)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_ANCIENT_ICE && PrimalAPI.randomCheck(PrimalCore.RANDOM, 16)) {
                for (k = 0; k < 32; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ANCIENT_ICE.func_176223_P(), 6 + PrimalCore.RANDOM.nextInt(16), WorldHelper.PREDICATE_END_STONE, "primal.world.end_stone").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(16, 36)));
                }
            }
        }
    }
}

