/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.BogIron;
import nmd.primal.core.common.blocks.ores.ClayLike;
import nmd.primal.core.common.blocks.ores.Magnetite;
import nmd.primal.core.common.blocks.ores.Opal;
import nmd.primal.core.common.blocks.ores.Zinc;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafe;
import nmd.primal.core.common.world.feature.GenOreSafeSub;
import nmd.primal.core.common.world.feature.GenSaltSpike;
import nmd.primal.core.common.world.feature.GenWadi;

public class NetherGeneral
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ModConfig.Worldgen.ENABLE_GENERATION_NETHER && (world.field_73011_w.func_186058_p() == DimensionType.NETHER || ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS && world.field_73011_w.func_177495_o())) {
            int k;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            PendingBlocks.getForWorld(world, "primal.world.nether").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_NETHER);
            PendingBlocks.getForWorld(world, "primal.world.nether_lava").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_NETHER_LAVA);
            if (ModConfig.Worldgen.ENABLE_NETHER_EARTH && PrimalAPI.randomCheck(PrimalCore.RANDOM, ModConfig.Worldgen.GEN_NETHER_EARTH_CHANCE)) {
                for (k = 0; k < 16; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.NETHER_EARTH.func_176223_P(), ModConfig.Worldgen.GEN_NETHER_EARTH_SIZE[0] + PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_NETHER_EARTH_SIZE[1]), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, 32));
                }
            }
            if (ModConfig.Worldgen.ENABLE_CINISCOTTA) {
                int bog_iron_chance;
                int n = bog_iron_chance = ModConfig.Worldgen.ENABLE_BOG_IRON ? 60 : 0;
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, ModConfig.Worldgen.GEN_CINIS_CLAY_CHANCE)) {
                    for (int i = 0; i < 6; ++i) {
                        new GenOreSafeSub(PrimalAPI.Blocks.CINIS_BLOCK.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.CINIS)), ModConfig.Worldgen.GEN_CINIS_CLAY_SIZE[0] + PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_CINIS_CLAY_SIZE[1]), bog_iron_chance, WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 32)));
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_SCORIA_STONE) {
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, ModConfig.Worldgen.GEN_SCORIA_STONE_SMALL_CHANCE)) {
                    for (k = 0; k < 24; ++k) {
                        new GenOreSafe(PrimalAPI.Blocks.SCORIA_STONE.func_176223_P(), ModConfig.Worldgen.GEN_SCORIA_STONE_SMALL_SIZE[0] + PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_SCORIA_STONE_SMALL_SIZE[0]), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, 28 + PrimalCore.RANDOM.nextInt(34)));
                    }
                }
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, ModConfig.Worldgen.GEN_SCORIA_STONE_CHANCE)) {
                    for (k = 0; k < 8; ++k) {
                        new GenOreSafe(PrimalAPI.Blocks.SCORIA_STONE.func_176223_P(), ModConfig.Worldgen.GEN_SCORIA_STONE_SIZE[0] + PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_SCORIA_STONE_SIZE[1]), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, 20 + PrimalCore.RANDOM.nextInt(40)));
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_FERRO_STONE) {
                int magnetite_chance;
                int n = magnetite_chance = ModConfig.Worldgen.ENABLE_MAGNETITE ? 90 : 0;
                if (PrimalAPI.randomCheck(PrimalCore.RANDOM, ModConfig.Worldgen.GEN_FERRO_STONE_CHANCE)) {
                    for (int k2 = 0; k2 < 8; ++k2) {
                        new GenOreSafeSub(PrimalAPI.Blocks.FERRO_STONE.func_176223_P(), PrimalAPI.Blocks.ORE_MAGNETITE.func_176223_P().func_177226_a(Magnetite.TYPE, (Comparable)((Object)Magnetite.Type.FERRO)), ModConfig.Worldgen.GEN_FERRO_STONE_SIZE[0] + PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_FERRO_STONE_SIZE[1]), magnetite_chance, WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(80, 120)));
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_NETHERWAX && PrimalAPI.randomCheck(PrimalCore.RANDOM, 200)) {
                for (k = 0; k < 2; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 36 + PrimalCore.RANDOM.nextInt(120), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(24, 120)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_MAGNETITE && PrimalAPI.randomCheck(160)) {
                for (k = 0; k < 16; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_MAGNETITE.func_176223_P().func_177226_a(Magnetite.TYPE, (Comparable)((Object)Magnetite.Type.NETHER)), PrimalCore.RANDOM.nextInt(2, 16), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_ZINC && PrimalAPI.randomCheck(40)) {
                for (k = 0; k < 16; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_ZINC.func_176223_P().func_177226_a(Zinc.TYPE, (Comparable)((Object)Zinc.Type.NETHER)), PrimalCore.RANDOM.nextInt(2, 16), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(40, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_OPAL && PrimalAPI.randomCheck(60)) {
                for (k = 0; k < 16; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_OPAL.func_176223_P().func_177226_a(Opal.TYPE, (Comparable)((Object)Opal.Type.NETHER)), PrimalCore.RANDOM.nextInt(1, 6), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 90)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_SALT_NETHER && PrimalAPI.randomCheck(PrimalCore.RANDOM, 40)) {
                for (k = 0; k < 16; ++k) {
                    new GenSaltSpike().func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(24, 32)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_ANCIENT_ICE && PrimalAPI.randomCheck(PrimalCore.RANDOM, 36)) {
                for (k = 0; k < 24; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ANCIENT_ICE.func_176223_P(), 16 + PrimalCore.RANDOM.nextInt(36), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(2, 9)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_MAGMA && PrimalAPI.randomCheck(PrimalCore.RANDOM, 16)) {
                for (k = 0; k < 8; ++k) {
                    new GenOreSafe(PrimalAPI.Fluids.MAGMA.getBlock().func_176223_P(), 6 + PrimalCore.RANDOM.nextInt(8), WorldHelper.PREDICATE_NETHER, "primal.world.nether").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(8, 16)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_BITUMEN && PrimalAPI.randomCheck(PrimalCore.RANDOM, 200)) {
                for (k = 0; k < 6; ++k) {
                    new GenWadi(PrimalAPI.Fluids.BITUMEN_BOILING.getBlock(), 24 + PrimalCore.RANDOM.nextInt(24)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(8, 64)));
                }
            }
        }
    }
}

