/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.BogIron;
import nmd.primal.core.common.blocks.ores.ClayLike;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafeSub;

public class OverWorldMud
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            int k;
            int bog_iron_chance;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            PendingBlocks.getForWorld(world, "primal.world.mud").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_MUD);
            if (ModConfig.Worldgen.ENABLE_MUD) {
                int n = bog_iron_chance = ModConfig.Worldgen.ENABLE_BOG_IRON ? 60 : 0;
                if (PrimalAPI.randomCheck(4) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.RIVER)) {
                    for (k = 0; k < 24; ++k) {
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.MUD_WET.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.MUD)), PrimalCore.RANDOM.nextInt(24, 64), bog_iron_chance, WorldHelper.PREDICATE_MUD, "primal.world.mud").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_MUD_MIN_MAX[0], ModConfig.Worldgen.GEN_MUD_MIN_MAX[1])))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(16) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH)) {
                    for (k = 0; k < 16; ++k) {
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.MUD_WET.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.MUD)), PrimalCore.RANDOM.nextInt(24, 64), bog_iron_chance, WorldHelper.PREDICATE_MUD, "primal.world.mud").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_MUD_MIN_MAX[0], ModConfig.Worldgen.GEN_MUD_MIN_MAX[1] + 24)))) continue;
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_TERRACOTTA) {
                int n = bog_iron_chance = ModConfig.Worldgen.ENABLE_BOG_IRON ? 60 : 0;
                if (PrimalAPI.randomCheck(10) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.SWAMP)) {
                    for (k = 0; k < 16; ++k) {
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.TERRA_BLOCK.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.TERRA)), PrimalCore.RANDOM.nextInt(16, 56), bog_iron_chance, WorldHelper.PREDICATE_MUD, "primal.world.mud").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_CLAY_MIN_MAX[0], ModConfig.Worldgen.GEN_CLAY_MIN_MAX[1])))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(16) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH)) {
                    for (k = 0; k < 16; ++k) {
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.TERRA_BLOCK.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.TERRA)), PrimalCore.RANDOM.nextInt(16, 96), bog_iron_chance, WorldHelper.PREDICATE_MUD, "primal.world.mud").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_CLAY_MIN_MAX[0], ModConfig.Worldgen.GEN_CLAY_MIN_MAX[1])))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(90) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.RARE)) {
                    for (k = 0; k < 24; ++k) {
                        if (!new GenOreSafeSub(PrimalAPI.Blocks.CINIS_BLOCK.func_176223_P(), PrimalAPI.Blocks.ORE_BOG_IRON.func_176223_P().func_177226_a(BogIron.TYPE, (Comparable)((Object)ClayLike.Type.CINIS)), PrimalCore.RANDOM.nextInt(26, 96), bog_iron_chance, WorldHelper.PREDICATE_MUD, "primal.world.mud").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_CLAY_MIN_MAX[0], ModConfig.Worldgen.GEN_CLAY_MIN_MAX[1])))) continue;
                    }
                }
            }
        }
    }
}

