/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafe;

public class OverWorldOcean
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            PendingBlocks.getForWorld(world, "primal.world.ocean").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_OCEAN);
            if (ModConfig.Worldgen.ENABLE_BLUE_SCHIST && PrimalAPI.randomCheck(16) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.OCEAN)) {
                for (int k = 0; k < 16; ++k) {
                    BlockPos ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), PrimalCore.RANDOM.nextInt(8, 55), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreSafe(PrimalAPI.Blocks.SCHIST_BLUE_STONE.func_176223_P(), PrimalCore.RANDOM.nextInt(24, 96), WorldHelper.PREDICATE_OCEAN, "primal.world.ocean").func_180709_b(world, PrimalCore.RANDOM, ore_pos)) continue;
                    PrimalAPI.logger(16, "world gen blue schist", "@" + ore_pos);
                }
            }
        }
    }
}

