/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.Magnetite;
import nmd.primal.core.common.blocks.ores.OreDensity;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreCloud;
import nmd.primal.core.common.world.feature.GenOreNearWater;
import nmd.primal.core.common.world.feature.GenOreSafe;

public class OverWorldOres
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            BlockPos ore_pos;
            int k;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            PendingBlocks.getForWorld(world, "primal.world.ores").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_ORES);
            if (ModConfig.Worldgen.ENABLE_SATETSU && PrimalAPI.randomCheck(60) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND)) {
                for (k = 0; k < 32; ++k) {
                    ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), 56 + PrimalCore.RANDOM.nextInt(12), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreNearWater(16 + PrimalCore.RANDOM.nextInt(46)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(ModConfig.Worldgen.GEN_SATETSU_MIN_MAX[0], ModConfig.Worldgen.GEN_SATETSU_MIN_MAX[1])))) continue;
                    PrimalAPI.logger(16, "world gen satestsu", "@" + ore_pos);
                }
            }
            if (ModConfig.Worldgen.ENABLE_MAGNETITE && PrimalAPI.randomCheck(260) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SWAMP)) {
                for (k = 0; k < 16; ++k) {
                    if (!new GenOreSafe(PrimalAPI.Blocks.ORE_MAGNETITE.func_176223_P().func_177226_a(Magnetite.TYPE, (Comparable)((Object)Magnetite.Type.STONE)), PrimalCore.RANDOM.nextInt(2, 8), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(16, 90)))) continue;
                }
            }
            if (ModConfig.Worldgen.ENABLE_ANCIENT_ICE && PrimalAPI.randomCheck(90) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WASTELAND)) {
                for (k = 0; k < 24; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ANCIENT_ICE.func_176223_P(), 6 + PrimalCore.RANDOM.nextInt(76), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(2, 9)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_PRIMAL_ORE_IRON && PrimalAPI.randomCheck(260) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MESA, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.COLD, BiomeDictionary.Type.OCEAN)) {
                for (int i = 0; i < 1 + PrimalCore.RANDOM.nextInt(1); ++i) {
                    ore_pos = new BlockPos(x + PrimalCore.RANDOM.nextInt(8), 28 + PrimalCore.RANDOM.nextInt(80), z + PrimalCore.RANDOM.nextInt(8));
                    if (!new GenOreCloud((OreDensity)PrimalAPI.Blocks.ORE_IRON, 20 + PrimalCore.RANDOM.nextInt(200)).func_180709_b(world, PrimalCore.RANDOM, ore_pos)) continue;
                    PrimalAPI.logger(16, "world gen", "iron@" + ore_pos);
                }
            }
            if (ModConfig.Worldgen.ENABLE_EARTHWAX) {
                if (PrimalAPI.randomCheck(1200) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD)) {
                    for (k = 0; k < 1; ++k) {
                        if (!new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 36 + PrimalCore.RANDOM.nextInt(886), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(36, 86)))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(360) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SPOOKY)) {
                    for (k = 0; k < 4 + PrimalCore.RANDOM.nextInt(4); ++k) {
                        if (!new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 36 + PrimalCore.RANDOM.nextInt(76), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(24, 76)))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(400) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS)) {
                    for (k = 0; k < 2 + PrimalCore.RANDOM.nextInt(2); ++k) {
                        if (!new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 80 + PrimalCore.RANDOM.nextInt(100), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(2, 24)))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(600) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD)) {
                    for (k = 0; k < 1 + PrimalCore.RANDOM.nextInt(3); ++k) {
                        if (!new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 96 + PrimalCore.RANDOM.nextInt(396), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(42, 62)))) continue;
                    }
                }
                if (PrimalAPI.randomCheck(600) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.OCEAN)) {
                    for (k = 0; k < 4 + PrimalCore.RANDOM.nextInt(8); ++k) {
                        if (!new GenOreSafe(PrimalAPI.Blocks.CALCIFIED_PARAFFIN.func_176223_P(), 90 + PrimalCore.RANDOM.nextInt(160), WorldHelper.PREDICATE_ORES, "primal.world.ores").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 32)))) continue;
                    }
                }
            }
        }
    }
}

