/*
 * Decompiled with CFR 0.152.
 */
package nmd.primal.core.common.world.generators;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.PrimalCore;
import nmd.primal.core.common.blocks.ores.SaltOre;
import nmd.primal.core.common.helper.WorldHelper;
import nmd.primal.core.common.init.ModConfig;
import nmd.primal.core.common.world.PendingBlocks;
import nmd.primal.core.common.world.feature.GenOreSafe;
import nmd.primal.core.common.world.feature.GenWadi;

public class OverWorldSalt
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && ModConfig.Worldgen.ENABLE_GENERATION_OVERWORLD || world.field_73011_w.func_76569_d() && ModConfig.Worldgen.ENABLE_MOD_DIMENSIONS) {
            int k;
            int x = WorldHelper.getChunkPos(chunkX);
            int z = WorldHelper.getChunkPos(chunkZ);
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            PendingBlocks.getForWorld(world, "primal.world.salt").processPending(new ChunkPos(chunkX, chunkZ), world, WorldHelper.PREDICATE_SALT);
            if (ModConfig.Worldgen.ENABLE_SALT_FLATS && PrimalAPI.randomCheck(80) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND)) {
                for (k = 0; k < 10; ++k) {
                    new GenWadi(PrimalAPI.Blocks.ORE_SALT_FLAT, PrimalCore.RANDOM.nextInt(24, 48)).func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(60, 120)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_SALT_ROCK) {
                if (PrimalAPI.randomCheck(80) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SAVANNA)) {
                    for (k = 0; k < 8; ++k) {
                        new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.ROCK)), PrimalCore.RANDOM.nextInt(24, 86), WorldHelper.PREDICATE_SALT, "primal.world.salt").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(40, 60)));
                    }
                }
                if (PrimalAPI.randomCheck(80) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH)) {
                    for (k = 0; k < 8; ++k) {
                        new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.ROCK)), PrimalCore.RANDOM.nextInt(40, 76), WorldHelper.PREDICATE_SALT, "primal.world.salt").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(20, 60)));
                    }
                }
                if (PrimalAPI.randomCheck(30) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD)) {
                    for (k = 0; k < 8; ++k) {
                        new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.ROCK)), PrimalCore.RANDOM.nextInt(16, 66), WorldHelper.PREDICATE_SALT, "primal.world.salt").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(2, 24)));
                    }
                }
            }
            if (ModConfig.Worldgen.ENABLE_SALT_END && PrimalAPI.randomCheck(160) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE)) {
                for (k = 0; k < 24; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.VOID)), PrimalCore.RANDOM.nextInt(6, 24), WorldHelper.PREDICATE_SALT, "primal.world.salt").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 55)));
                }
            }
            if (ModConfig.Worldgen.ENABLE_SALT_NETHER && PrimalAPI.randomCheck(160) && WorldHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD)) {
                for (k = 0; k < 24; ++k) {
                    new GenOreSafe(PrimalAPI.Blocks.ORE_SALT.func_176223_P().func_177226_a(SaltOre.TYPE, (Comparable)((Object)SaltOre.Type.FIRE)), PrimalCore.RANDOM.nextInt(6, 16), WorldHelper.PREDICATE_SALT, "primal.world.salt").func_180709_b(world, PrimalCore.RANDOM, WorldHelper.getWorldGenPos(x, z, PrimalCore.RANDOM.nextInt(6, 55)));
                }
            }
        }
    }
}

