/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol;

import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.worldgenerator.WorldGeneratorReplacementFirst;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.worldgenerator.WorldGeneratorReplacementLast;
import com.bloodnbonesgaming.dimensionalcontrol.commands.Commands;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.DefaultConfigs;
import com.bloodnbonesgaming.dimensionalcontrol.events.CoreEventHandler;
import com.bloodnbonesgaming.dimensionalcontrol.events.DCEventHandler;
import com.bloodnbonesgaming.dimensionalcontrol.proxy.CommonProxy;
import com.bloodnbonesgaming.lib.BNBGamingMod;
import com.bloodnbonesgaming.lib.util.script.ScriptDocumentationHandler;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="dimensionalcontrol", name="Dimensional Control", version="2.13.0", dependencies="required-after:bnbgaminglib@[2.12.0,)", acceptedMinecraftVersions="[1.12,1.13)", customProperties={@Mod.CustomProperty(k="clientMessageConsumer", v="com.bloodnbonesgaming.dimensionalcontrol.network.ClientMessageConsumer")})
public class DimensionalControl
extends BNBGamingMod {
    @Mod.Instance(value="dimensionalcontrol")
    public static DimensionalControl instance;
    @SidedProxy(clientSide="com.bloodnbonesgaming.dimensionalcontrol.proxy.ClientProxy", serverSide="com.bloodnbonesgaming.dimensionalcontrol.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static boolean topography;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"bnbgamingcore")) {
            MinecraftForge.EVENT_BUS.register((Object)new CoreEventHandler());
        } else {
            instance.getLog().info((Object)"It seems BnBGamingCore is not loaded. This means most options won't work. :(");
        }
        if (Loader.isModLoaded((String)"topography")) {
            topography = true;
        }
        ScriptDocumentationHandler.setScriptDocs((ASMDataTable)event.getAsmData());
        DCEventHandler eventHandler = new DCEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        proxy.preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorReplacementFirst(), (int)Integer.MIN_VALUE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorReplacementLast(), (int)Integer.MAX_VALUE);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        File mainConfig = new File("./config/dimensionalcontrol/DimensionalControl.cfg");
        if (!mainConfig.exists()) {
            instance.getLog().info((Object)"Printing default configs.");
            DefaultConfigs.printDefaultConfigs();
            instance.getLog().info((Object)"Printing documentation to config/dimensionalcontrol/documentation/");
            ScriptDocumentationHandler.printAnnotatedDocumentation((String)"com.bloodnbonesgaming.dimensionalcontrol");
            ScriptDocumentationHandler.copyDocumentationFolder(ConfigurationManager.class, (String)"./config/dimensionalcontrol/documentation/");
        }
    }

    @Mod.EventHandler
    public void serverAboutToSTart(FMLServerAboutToStartEvent event) {
        proxy.serverAboutToStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) throws IOException {
        Commands.init(event);
        ConfigurationManager.getInstance().printBiomes();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        this.clearData();
        ConfigurationManager.cleanUp();
    }

    private void clearData() {
        if (Loader.isModLoaded((String)"bnbgamingcore")) {
            CoreEventHandler.clearMapGenWorldMap();
        }
    }

    static {
        topography = false;
    }
}

