/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.block;

import com.bloodnbonesgaming.dimensionalcontrol.block.ModBlocks;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.PortalDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.tileentity.TileEntityPortalCustom;
import com.bloodnbonesgaming.dimensionalcontrol.util.TeleportUtils;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortalCustom
extends BlockBreakable
implements ITileEntityProvider {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockPortalCustom(String unlocalizedName, String registryName) {
        super(Material.field_151567_E, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName("dimensionalcontrol", registryName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean trySpawnPortal(World worldIn, BlockPos pos, PortalDefinition definition, byte portalID) {
        Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X, definition);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks(portalID);
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z, definition);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks(portalID);
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityPortalCustom tileEntity = (TileEntityPortalCustom)worldIn.func_175625_s(pos);
        PortalDefinition definition = ConfigurationManager.getInstance().getPortalDefinition(tileEntity.getPortalID());
        if (definition != null) {
            Size blockportal$size1;
            EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
            if (enumfacing$axis == EnumFacing.Axis.X) {
                Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X, definition);
                if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            } else if (!(enumfacing$axis != EnumFacing.Axis.Z || (blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z, definition)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean flag5;
        pos = pos.func_177972_a(side);
        EnumFacing.Axis enumfacing$axis = null;
        if (blockState.func_177230_c() == this) {
            enumfacing$axis = (EnumFacing.Axis)blockState.func_177229_b(AXIS);
            if (enumfacing$axis == null) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.Z && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return false;
            }
            if (enumfacing$axis == EnumFacing.Axis.X && side != EnumFacing.SOUTH && side != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean flag = blockAccess.func_180495_p(pos.func_177976_e()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag1 = blockAccess.func_180495_p(pos.func_177974_f()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag2 = blockAccess.func_180495_p(pos.func_177978_c()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag3 = blockAccess.func_180495_p(pos.func_177968_d()).func_177230_c() == this && blockAccess.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag4 = flag || flag1 || enumfacing$axis == EnumFacing.Axis.X;
        boolean bl = flag5 = flag2 || flag3 || enumfacing$axis == EnumFacing.Axis.Z;
        return flag4 && side == EnumFacing.WEST ? true : (flag4 && side == EnumFacing.EAST ? true : (flag5 && side == EnumFacing.NORTH ? true : flag5 && side == EnumFacing.SOUTH));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && worldIn instanceof WorldServer && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            PortalDefinition definition = ConfigurationManager.getInstance().getPortalDefinition(((TileEntityPortalCustom)worldIn.func_175625_s(pos)).getPortalID());
            if (!pos.equals((Object)entityIn.field_181016_an)) {
                entityIn.field_181016_an = new BlockPos((Vec3i)pos);
                BlockPattern.PatternHelper blockpattern$patternhelper = ModBlocks.blockDimensionalPortal.createPatternHelper(entityIn.field_70170_p, entityIn.field_181016_an, definition);
                double d0 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
                double d1 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? entityIn.field_70161_v : entityIn.field_70165_t;
                d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)blockpattern$patternhelper.func_181118_d())));
                double d2 = MathHelper.func_181160_c((double)(entityIn.field_70163_u - 1.0), (double)blockpattern$patternhelper.func_181117_a().func_177956_o(), (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() - blockpattern$patternhelper.func_181119_e()));
                entityIn.field_181017_ao = new Vec3d(d1, d2, 0.0);
                entityIn.field_181018_ap = blockpattern$patternhelper.func_177669_b();
            }
            TeleportUtils.teleportPlayer(entityIn, definition.getDimensionID1() == worldIn.field_73011_w.getDimension() ? definition.getDimensionID2() : definition.getDimensionID1(), definition);
        } else if (worldIn.field_72995_K && entityIn instanceof EntityPlayer) {
            entityIn.field_71087_bX = true;
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public int func_176201_c(IBlockState state) {
        return BlockPortalCustom.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public BlockPattern.PatternHelper createPatternHelper(World worldIn, BlockPos p_181089_2_, PortalDefinition definition) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Z;
        Size blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.X, definition);
        LoadingCache loadingcache = BlockPattern.func_181627_a((World)worldIn, (boolean)true);
        if (!blockportal$size.isValid()) {
            enumfacing$axis = EnumFacing.Axis.X;
            blockportal$size = new Size(worldIn, p_181089_2_, EnumFacing.Axis.Z, definition);
        }
        if (!blockportal$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, EnumFacing.NORTH, EnumFacing.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing enumfacing = blockportal$size.rightDir.func_176735_f();
        BlockPos blockpos = blockportal$size.bottomLeft.func_177981_b(blockportal$size.getHeight() - 1);
        for (EnumFacing.AxisDirection enumfacing$axisdirection : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
            for (int i = 0; i < blockportal$size.getWidth(); ++i) {
                for (int j = 0; j < blockportal$size.getHeight(); ++j) {
                    BlockWorldState blockworldstate = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (blockworldstate.func_177509_a() == null || blockworldstate.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = enumfacing$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection enumfacing$axisdirection1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection enumfacing$axisdirection2 : EnumFacing.AxisDirection.values()) {
            if (aint[enumfacing$axisdirection2.ordinal()] >= aint[enumfacing$axisdirection1.ordinal()]) continue;
            enumfacing$axisdirection1 = enumfacing$axisdirection2;
        }
        return new BlockPattern.PatternHelper(enumfacing.func_176743_c() == enumfacing$axisdirection1 ? blockpos : blockpos.func_177967_a(blockportal$size.rightDir, blockportal$size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)enumfacing$axisdirection1, (EnumFacing.Axis)enumfacing$axis), EnumFacing.UP, loadingcache, blockportal$size.getWidth(), blockportal$size.getHeight(), 1);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPortalCustom();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPortalCustom();
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final PortalDefinition definition;

        public Size(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_, PortalDefinition definition) {
            this.world = worldIn;
            this.axis = p_i45694_3_;
            this.definition = definition;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i45694_2_;
            while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()).func_177230_c())) {
                p_i45694_2_ = p_i45694_2_.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, EnumFacing p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.definition.correctBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            IBlockState block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i));
            return this.definition.correctBlock(block) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    IBlockState block = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(block)) break block0;
                    if (block.func_177230_c() == ModBlocks.blockDimensionalPortal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.definition.correctBlock(block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) : i == this.width - 1 && !this.definition.correctBlock(block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)))) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.definition.correctBlock(this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)))) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState blockIn) {
            return this.isEmptyBlock(blockIn.func_177230_c());
        }

        protected boolean isEmptyBlock(Block blockIn) {
            return blockIn.field_149764_J == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == ModBlocks.blockDimensionalPortal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks(byte portalID) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), ModBlocks.blockDimensionalPortal.func_176223_P().func_177226_a(AXIS, (Comparable)this.axis), 2);
                    ((TileEntityPortalCustom)this.world.func_175625_s(blockpos.func_177981_b(j))).setPortalID(portalID);
                }
            }
        }
    }
}

