/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class ArgumentUtils {
    public static int[] toBiomeIDArray(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                int biomeID = ArgumentUtils.getBiomeID((String)obj);
                if (biomeID != -1) {
                    return new int[]{biomeID};
                }
            } else {
                if (obj instanceof Integer) {
                    return new int[]{(Integer)obj};
                }
                if (obj instanceof int[]) {
                    return (int[])obj;
                }
                if (obj instanceof String[]) {
                    String[] array = (String[])obj;
                    ArrayList<Integer> values = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        int biomeID = ArgumentUtils.getBiomeID(array[i2]);
                        if (biomeID == -1) continue;
                        values.add(biomeID);
                    }
                    if (values.size() > 0) {
                        return values.stream().mapToInt(i -> i).toArray();
                    }
                }
            }
        }
        return null;
    }

    public static int toBiomeID(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            return ArgumentUtils.getBiomeID((String)obj);
        }
        return -1;
    }

    public static int getBiomeID(String biomeString) {
        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeString));
        if (biome != null) {
            int biomeID = Biome.func_185362_a((Biome)biome);
            return biomeID;
        }
        DimensionalControl.instance.getLog().error((Object)("No biome found for String id: " + biomeString));
        return -1;
    }
}

