/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.util.DefaultBiomeColors;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.DimensionManager;

public class BiomePrinter {
    private int dimensionID;
    private int height = 500;
    private int width = 500;
    private int spacing = 10;
    private int startX = 0;
    private int startZ = 0;
    private boolean overwrite = false;

    public BiomePrinter(int dimensionID, int height, int width, int spacing, int startX, int startZ, boolean overwrite) {
        this.dimensionID = dimensionID;
        this.height = height;
        this.width = width;
        this.spacing = spacing;
        this.startX = startX;
        this.startZ = startZ;
        this.overwrite = overwrite;
    }

    public void print() throws IOException {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionID);
        if (world != null) {
            DimensionalControl.instance.getLog().info((Object)("Starting image for dimension " + this.dimensionID));
            int percent = 0;
            BiomeProvider provider = world.func_72959_q();
            BufferedImage image = new BufferedImage(this.width, this.height, 1);
            Biome[] biomes = new Biome[1];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int value = DefaultBiomeColors.getColorForBiome(provider.func_76931_a(biomes, this.startX + x * this.spacing, this.startZ + y * this.spacing, 1, 1, false)[0]);
                    image.setRGB(x, y, value);
                }
                if (y == 0 || y % (this.height / 10) != 0) continue;
                DimensionalControl.instance.getLog().info((Object)("Image for dimension " + this.dimensionID + " is " + (percent += 10) + " percent complete"));
            }
            File output = this.overwrite ? new File("./config/dimensionalcontrol/output/", this.dimensionID + ".png") : BiomePrinter.findOpenImageFile(this.dimensionID);
            output.getParentFile().mkdirs();
            output.createNewFile();
            ImageIO.write((RenderedImage)image, "png", output);
            DimensionalControl.instance.getLog().info((Object)("Finished image for dimension " + this.dimensionID));
        }
    }

    public static File findOpenImageFile(int dimensionID) {
        File file = new File("./config/dimensionalcontrol/output/", dimensionID + ".png");
        int count = 1;
        while (file.isFile()) {
            file = new File("./config/dimensionalcontrol/output/", dimensionID + "_" + count + ".png");
            ++count;
        }
        return file;
    }
}

