/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.util;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacement;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.DimensionDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.MainConfig;
import com.bloodnbonesgaming.dimensionalcontrol.config.WorldInfoDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.worldprovider.WorldProviderDefinition;
import com.bloodnbonesgaming.lib.util.FileHelper;
import com.bloodnbonesgaming.lib.util.script.ScriptUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class IOHelper {
    public static String loadPreset(MinecraftServer server, boolean dedicated) {
        File file = new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I() + "/DimensionalControlPreset.txt");
        try {
            BufferedReader reader = FileHelper.openReader((File)file);
            String preset = reader.readLine();
            reader.close();
            return preset;
        }
        catch (IOException e) {
            if (dedicated) {
                DimensionalControl.instance.getLog().error((Object)"Error loading preset. Attempting to get from the server.properties file. If this is the first time loading a world, this is entirely normal.");
            } else {
                DimensionalControl.instance.getLog().error((Object)"Error loading preset. Setting to Default.");
            }
            return null;
        }
    }

    public static void savePreset(MinecraftServer server, String preset) {
        File file = new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I() + "/DimensionalControlPreset.txt");
        try {
            file.getParentFile().mkdirs();
            BufferedWriter writer = FileHelper.openWriter((File)file);
            writer.write(preset);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            DimensionalControl.instance.getLog().error((Object)"Error saving preset.");
            e.printStackTrace();
        }
    }

    public static boolean loadDimensionsFile(ConfigurationManager manager) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile(""), "Dimensions.cfg"), (Object)manager, null);
    }

    public static boolean loadMainConfig(MainConfig config) {
        return ScriptUtil.readScript((File)new File("./config/dimensionalcontrol/DimensionalControl.cfg"), (Object)config, null);
    }

    public static boolean loadWorldInfoDefinition(String name, WorldInfoDefinition definition) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("worldinfo/"), name + ".cfg"), (Object)definition, null);
    }

    public static boolean loadWorldProviderDefinition(String name, WorldProviderDefinition definition) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("worldproviders/"), name + ".cfg"), (Object)definition, null);
    }

    public static boolean loadChunkGeneratorDefinition(String name, ChunkGeneratorDefinition definition) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("chunkgenerators/"), name + ".cfg"), (Object)definition, null);
    }

    public static boolean loadBiomeProviderDefinition(String name, BiomeProviderDefinition definition) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("biomeproviders/"), name + ".cfg"), (Object)definition, null);
    }

    public static boolean loadBiomeProvider(String name, Object mainObj, Map<String, Class> classKeywords, Map<String, Object> localVariables) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("biomeproviders/"), name + ".cfg"), (Object)mainObj, classKeywords, localVariables);
    }

    public static boolean loadBlockReplacement(String replacementName, BlockReplacement replacement) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("blockreplacements/"), replacementName + ".cfg"), (Object)replacement, null);
    }

    public static boolean loadDimensionDefinition(String definitionName, DimensionDefinition definition) {
        return ScriptUtil.readScript((File)new File(ConfigurationManager.getInstance().getConfigFile("dimensions/"), definitionName + ".cfg"), (Object)definition, null);
    }
}

