/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.capabilities;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Config;
import com.google.common.primitives.Floats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleImpl
implements INutrientManager {
    private Map<Nutrient, Float> nutrition = new HashMap<Nutrient, Float>();

    public SimpleImpl() {
        this.updateCapability();
    }

    @Override
    public Map<Nutrient, Float> get() {
        return this.nutrition;
    }

    @Override
    public Float get(Nutrient nutrient) {
        return this.nutrition.get(nutrient);
    }

    @Override
    public void set(Nutrient nutrient, Float value) {
        this.nutrition.put(nutrient, value);
    }

    @Override
    public void set(Map<Nutrient, Float> nutrientData) {
        for (Map.Entry<Nutrient, Float> entry : nutrientData.entrySet()) {
            this.nutrition.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void add(Nutrient nutrient, float amount) {
        float currentAmount = this.nutrition.get(nutrient).floatValue();
        this.nutrition.put(nutrient, Float.valueOf(Floats.constrainToRange((float)(currentAmount + amount), (float)0.0f, (float)100.0f)));
    }

    @Override
    public void add(List<Nutrient> nutrientData, float amount) {
        for (Nutrient nutrient : nutrientData) {
            this.nutrition.put(nutrient, Float.valueOf(Floats.constrainToRange((float)(this.nutrition.get(nutrient).floatValue() + amount), (float)0.0f, (float)100.0f)));
        }
    }

    @Override
    public void subtract(Nutrient nutrient, float amount) {
        float currentAmount = this.nutrition.get(nutrient).floatValue();
        this.nutrition.put(nutrient, Float.valueOf(Floats.constrainToRange((float)(currentAmount - amount), (float)0.0f, (float)100.0f)));
    }

    @Override
    public void subtract(List<Nutrient> nutrientData, float amount) {
        for (Nutrient nutrient : nutrientData) {
            this.nutrition.put(nutrient, Float.valueOf(Floats.constrainToRange((float)(this.nutrition.get(nutrient).floatValue() - amount), (float)0.0f, (float)100.0f)));
        }
    }

    @Override
    public void reset(Nutrient nutrient) {
        this.set(nutrient, Float.valueOf(Config.startingNutrition));
    }

    @Override
    public void reset() {
        for (Nutrient nutrient : this.nutrition.keySet()) {
            this.reset(nutrient);
        }
    }

    @Override
    public void updateCapability() {
        HashMap<Nutrient, Float> nutritionOld = new HashMap<Nutrient, Float>(this.nutrition);
        this.nutrition.clear();
        block0: for (Nutrient nutrient : NutrientList.get()) {
            for (Map.Entry nutrientOld : nutritionOld.entrySet()) {
                if (!nutrient.name.equals(((Nutrient)nutrientOld.getKey()).name)) continue;
                this.nutrition.put(nutrient, (Float)nutrientOld.getValue());
                continue block0;
            }
            this.nutrition.put(nutrient, Float.valueOf(Config.startingNutrition));
        }
    }
}

