/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.command;

import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ISyncAction;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.command.SubCommandAction;
import com.buuz135.togetherforever.api.data.DefaultPlayerInformation;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ForceSyncCommand
extends SubCommandAction {
    public ForceSyncCommand() {
        super("forcesync");
    }

    @Override
    public boolean execute(MinecraftServer server, ICommandSender sender, String[] args) {
        try {
            EntityPlayerMP senderPlayer = CommandBase.func_71521_c((ICommandSender)sender);
            ITogetherTeam togetherTeam = TogetherForeverAPI.getInstance().getPlayerTeam(senderPlayer.func_110124_au());
            if (togetherTeam != null) {
                for (IPlayerInformation playerInformation : togetherTeam.getPlayers()) {
                    EntityPlayerMP playerMP = playerInformation.getPlayer();
                    if (playerMP == null || senderPlayer.func_110124_au().equals(playerMP.func_110124_au())) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Trying to sync data from " + playerMP.func_70005_c_() + " please don't hurt yourself in the process!"));
                    for (ISyncAction<?, IOfflineSyncRecovery> action : TogetherRegistries.getSyncActions()) {
                        action.syncJoinPlayer(DefaultPlayerInformation.createInformation(senderPlayer), playerInformation);
                    }
                }
                return true;
            }
        }
        catch (PlayerNotFoundException e) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(e.getLocalizedMessage(), e.func_74844_a()));
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getInfo() {
        return "Forces a sync from another player of the team";
    }
}

