/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.gson.JsonObject;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.types.ComponentEnergy;
import hellfirepvp.modularmachinery.common.crafting.types.ComponentFluid;
import hellfirepvp.modularmachinery.common.crafting.types.ComponentGas;
import hellfirepvp.modularmachinery.common.crafting.types.ComponentItem;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class ComponentType<R extends ComponentRequirement> {
    @Nonnull
    public abstract String getRegistryName();

    @Nullable
    public abstract String requiresModid();

    @Nonnull
    public abstract R provideComponent(MachineComponent.IOType var1, JsonObject var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentType that = (ComponentType)o;
        return this.getRegistryName().equalsIgnoreCase(that.getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public static class ComponentRegistryEvent
    extends Event {
    }

    public static class Registry {
        private static boolean initialized = false;
        private static Map<String, ComponentType> components = new HashMap<String, ComponentType>();

        public static void register(ComponentType type) {
            if (components.containsKey(type.getRegistryName())) {
                throw new IllegalArgumentException("Component with registry name " + type.getRegistryName() + " already exists!");
            }
            if (type.requiresModid() != null && !Loader.isModLoaded((String)type.requiresModid())) {
                ModularMachinery.log.info("[Modular Machinery] ignoring componenttype " + type.getRegistryName() + " because " + type.requiresModid() + " is not loaded!");
                return;
            }
            components.put(type.getRegistryName(), type);
        }

        public static void initialize() {
            if (initialized) {
                return;
            }
            Registry.register(new ComponentItem());
            Registry.register(new ComponentFluid());
            Registry.register(new ComponentEnergy());
            Registry.register(new ComponentGas());
            MinecraftForge.EVENT_BUS.post((Event)new ComponentRegistryEvent());
            initialized = true;
        }

        @Nullable
        public static ComponentType getComponent(String name) {
            for (String key : components.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                return components.get(key);
            }
            return null;
        }
    }
}

