/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterRegistry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class RecipeAdapterAccessor {
    private final ResourceLocation owningMachine;
    private final ResourceLocation adapterKey;
    private List<MachineRecipe> cacheLoaded = new LinkedList<MachineRecipe>();

    private RecipeAdapterAccessor(ResourceLocation owningMachine, ResourceLocation adapterKey) {
        this.owningMachine = owningMachine;
        this.adapterKey = adapterKey;
    }

    public ResourceLocation getOwningMachine() {
        return this.owningMachine;
    }

    public ResourceLocation getAdapterKey() {
        return this.adapterKey;
    }

    public List<MachineRecipe> loadRecipesForAdapter() {
        this.cacheLoaded.clear();
        Collection<MachineRecipe> recipes = RecipeAdapterRegistry.createRecipesFor(this.owningMachine, this.adapterKey);
        if (recipes != null) {
            this.cacheLoaded.addAll(recipes);
        }
        return this.cacheLoaded;
    }

    public List<MachineRecipe> getCachedRecipes() {
        return ImmutableList.copyOf(this.cacheLoaded);
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeAdapterAccessor> {
        public RecipeAdapterAccessor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            if (!root.has("machine")) {
                throw new JsonParseException("No 'machine'-entry specified!");
            }
            if (!root.has("adapter")) {
                throw new JsonParseException("No 'adapter'-entry specified!");
            }
            JsonElement elementMachine = root.get("machine");
            if (!elementMachine.isJsonPrimitive() || !elementMachine.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("'machine' has to have as value only a String that defines its owning machine!");
            }
            JsonElement elementAdapter = root.get("adapter");
            if (!elementAdapter.isJsonPrimitive() || !elementAdapter.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("'adapter' has to have as value only a String that defines the name of the adapter!");
            }
            ResourceLocation owningMachineKey = new ResourceLocation("modularmachinery", elementMachine.getAsJsonPrimitive().getAsString());
            ResourceLocation adapterKey = new ResourceLocation(elementAdapter.getAsJsonPrimitive().getAsString());
            return new RecipeAdapterAccessor(owningMachineKey, adapterKey);
        }
    }
}

