/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeCraftingContext {
    private static final Random RAND = new Random();
    private final MachineRecipe recipe;
    private int currentCraftingTick = 0;
    private Map<String, Map<MachineComponent, Object>> typeComponents = new HashMap<String, Map<MachineComponent, Object>>();
    private Map<String, List<RecipeModifier>> modifiers = new HashMap<String, List<RecipeModifier>>();
    private List<ComponentOutputRestrictor> currentRestrictions = Lists.newArrayList();

    public RecipeCraftingContext(MachineRecipe recipe) {
        this.recipe = recipe;
    }

    public MachineRecipe getParentRecipe() {
        return this.recipe;
    }

    public void setCurrentCraftingTick(int currentCraftingTick) {
        this.currentCraftingTick = currentCraftingTick;
    }

    public int getCurrentCraftingTick() {
        return this.currentCraftingTick;
    }

    @Nonnull
    public List<RecipeModifier> getModifiers(String target) {
        return this.modifiers.computeIfAbsent(target, t -> new LinkedList());
    }

    public float applyModifiers(ComponentRequirement reqTarget, MachineComponent.IOType ioType, float value, boolean isChance) {
        return this.applyModifiers(reqTarget.getRequiredComponentType().getRegistryName(), ioType, value, isChance);
    }

    public float applyModifiers(String target, MachineComponent.IOType ioType, float value, boolean isChance) {
        List<RecipeModifier> applicable = this.getModifiers(target);
        applicable = applicable.stream().filter(mod -> (ioType == null || mod.getIOTarget() == ioType) && mod.affectsChance() == isChance).collect(Collectors.toList());
        float add = 0.0f;
        float mul = 1.0f;
        for (RecipeModifier mod2 : applicable) {
            if (mod2.getOperation() == 0) {
                add += mod2.getModifier();
                continue;
            }
            if (mod2.getOperation() == 1) {
                mul *= mod2.getModifier();
                continue;
            }
            throw new RuntimeException("Unknown modifier operation: " + mod2.getOperation() + " at recipe " + this.recipe.getRegistryName());
        }
        return (value + add) * mul;
    }

    public float getDurationMultiplier() {
        float dur = this.recipe.getRecipeTotalTickTime();
        float result = this.applyModifiers("duration", null, dur, false);
        return dur / result;
    }

    public void addRestriction(ComponentOutputRestrictor restrictor) {
        this.currentRestrictions.add(restrictor);
    }

    public Collection<MachineComponent> getComponentsFor(ComponentType type) {
        String key = type.getRegistryName();
        if (key.equalsIgnoreCase("gas")) {
            key = "fluid";
        }
        return this.typeComponents.computeIfAbsent(key, s -> new HashMap()).keySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean energyTick() {
        ComponentRequirement.PerTick perTickRequirement;
        ComponentRequirement requirement;
        Iterator<ComponentRequirement> iterator;
        float durMultiplier;
        block13: {
            durMultiplier = this.getDurationMultiplier();
            iterator = this.recipe.getCraftingRequirements().iterator();
            while (true) {
                if (!iterator.hasNext()) break block13;
                requirement = iterator.next();
                if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == MachineComponent.IOType.OUTPUT) continue;
                perTickRequirement = (ComponentRequirement.PerTick)requirement;
                perTickRequirement.resetIOTick(this);
                perTickRequirement.startIOTick(this, durMultiplier);
                boolean enough = false;
                block9: for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                    ComponentRequirement.CraftCheck result = perTickRequirement.doIOTick(component, this);
                    switch (result) {
                        case SUCCESS: {
                            enough = true;
                            break block9;
                        }
                        default: {
                            continue block9;
                        }
                    }
                }
                perTickRequirement.resetIOTick(this);
                if (!enough) break;
            }
            return false;
        }
        iterator = this.recipe.getCraftingRequirements().iterator();
        while (iterator.hasNext()) {
            requirement = iterator.next();
            if (!(requirement instanceof ComponentRequirement.PerTick) || requirement.getActionType() == MachineComponent.IOType.INPUT) continue;
            perTickRequirement = (ComponentRequirement.PerTick)requirement;
            perTickRequirement.resetIOTick(this);
            perTickRequirement.startIOTick(this, durMultiplier);
            block11: for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                ComponentRequirement.CraftCheck result = perTickRequirement.doIOTick(component, this);
                switch (result) {
                    case SUCCESS: {
                        break block11;
                    }
                    case PARTIAL_SUCCESS: {
                        break;
                    }
                    case FAILURE_MISSING_INPUT: 
                }
            }
            perTickRequirement.resetIOTick(this);
        }
        return true;
    }

    public void startCrafting() {
        this.startCrafting(RAND.nextLong());
    }

    public void startCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (requirement.getActionType() == MachineComponent.IOType.OUTPUT) continue;
            requirement.startRequirementCheck(chance, this);
            for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                if (!requirement.startCrafting(component, this, chance)) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
    }

    public void finishCrafting() {
        this.finishCrafting(RAND.nextLong());
    }

    public void finishCrafting(long seed) {
        ResultChance chance = new ResultChance(seed);
        for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (requirement.getActionType() == MachineComponent.IOType.INPUT) continue;
            requirement.startRequirementCheck(chance, this);
            for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                if (!requirement.finishCrafting(component, this, chance)) continue;
                requirement.endRequirementCheck();
                break;
            }
            requirement.endRequirementCheck();
        }
    }

    public ComponentRequirement.CraftCheck canStartCrafting() {
        this.currentRestrictions.clear();
        block0: for (ComponentRequirement requirement : this.recipe.getCraftingRequirements()) {
            if (requirement.getRequiredComponentType().equals(ComponentType.Registry.getComponent("energy")) && requirement.getActionType() == MachineComponent.IOType.OUTPUT) {
                for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                    if (component.getIOType() != MachineComponent.IOType.OUTPUT) continue;
                    continue block0;
                }
                return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
            }
            requirement.startRequirementCheck(ResultChance.GUARANTEED, this);
            for (MachineComponent component : this.getComponentsFor(requirement.getRequiredComponentType())) {
                ComponentRequirement.CraftCheck check = requirement.canStartCrafting(component, this, this.currentRestrictions);
                if (check != ComponentRequirement.CraftCheck.SUCCESS) continue;
                requirement.endRequirementCheck();
                continue block0;
            }
            requirement.endRequirementCheck();
            this.currentRestrictions.clear();
            return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
        }
        this.currentRestrictions.clear();
        return ComponentRequirement.CraftCheck.SUCCESS;
    }

    public void addComponent(MachineComponent<?> component) {
        Map components = this.typeComponents.computeIfAbsent(component.getComponentType().getRegistryName(), s -> new HashMap());
        components.put(component, component.getContainerProvider());
    }

    public void addModifier(ModifierReplacement modifier) {
        RecipeModifier mod = modifier.getModifier();
        this.modifiers.computeIfAbsent(mod.getTarget(), target -> new LinkedList()).add(mod);
    }

    @Nullable
    public Object getProvidedCraftingComponent(MachineComponent component) {
        Map components = this.typeComponents.computeIfAbsent(component.getComponentType().getRegistryName(), s -> new HashMap());
        return components.getOrDefault(component, null);
    }
}

