/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirements;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirements.jei.JEIComponentEnergy;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementEnergy
extends ComponentRequirement.PerTick<Long> {
    public final int requirementPerTick;
    private int activeIO;

    public RequirementEnergy(MachineComponent.IOType ioType, int requirementPerTick) {
        super(ComponentType.Registry.getComponent("energy"), ioType);
        this.activeIO = this.requirementPerTick = requirementPerTick;
    }

    @Override
    public ComponentRequirement<Long> deepCopy() {
        RequirementEnergy energy = new RequirementEnergy(this.getActionType(), this.requirementPerTick);
        energy.activeIO = this.activeIO;
        return energy;
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    @Override
    public void endRequirementCheck() {
    }

    public int getRequiredEnergyPerTick() {
        return this.requirementPerTick;
    }

    @Override
    public ComponentRequirement.JEIComponent<Long> provideJEIComponent() {
        return new JEIComponentEnergy(this);
    }

    @Override
    public ComponentRequirement.CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        if (!component.getComponentType().equals(this.getRequiredComponentType()) || !(component instanceof MachineComponent.EnergyHatch) || component.getIOType() != this.getActionType()) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        IEnergyHandler handler = (IEnergyHandler)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                if (!((float)handler.getCurrentEnergy() >= context.applyModifiers(this, this.getActionType(), (float)this.requirementPerTick, false))) break;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
            case OUTPUT: {
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.FAILURE_MISSING_INPUT;
    }

    @Override
    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()) == ComponentRequirement.CraftCheck.SUCCESS;
    }

    @Override
    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return true;
    }

    @Override
    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.activeIO = Math.round(context.applyModifiers(this, this.getActionType(), (float)this.activeIO, false) * durationMultiplier);
    }

    @Override
    public void resetIOTick(RecipeCraftingContext context) {
        this.activeIO = this.requirementPerTick;
    }

    @Override
    @Nonnull
    public ComponentRequirement.CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (!component.getComponentType().equals(this.getRequiredComponentType()) || !(component instanceof MachineComponent.EnergyHatch) || component.getIOType() != this.getActionType()) {
            return ComponentRequirement.CraftCheck.INVALID_SKIP;
        }
        IEnergyHandler handler = (IEnergyHandler)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                if (handler.getCurrentEnergy() >= this.activeIO) {
                    handler.setCurrentEnergy(handler.getCurrentEnergy() - this.activeIO);
                    this.activeIO = 0;
                    return ComponentRequirement.CraftCheck.SUCCESS;
                }
                this.activeIO -= handler.getCurrentEnergy();
                handler.setCurrentEnergy(0);
                return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
            }
            case OUTPUT: {
                int remaining = handler.getRemainingCapacity();
                if (remaining - this.activeIO < 0) {
                    handler.setCurrentEnergy(handler.getMaxEnergy());
                    this.activeIO -= remaining;
                    return ComponentRequirement.CraftCheck.PARTIAL_SUCCESS;
                }
                handler.setCurrentEnergy(Math.min(handler.getCurrentEnergy() + this.activeIO, handler.getMaxEnergy()));
                this.activeIO = 0;
                return ComponentRequirement.CraftCheck.SUCCESS;
            }
        }
        return ComponentRequirement.CraftCheck.INVALID_SKIP;
    }
}

