/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentEnergy
extends ComponentType<RequirementEnergy> {
    @Override
    @Nonnull
    public String getRegistryName() {
        return "energy";
    }

    @Override
    @Nullable
    public String requiresModid() {
        return null;
    }

    @Override
    @Nonnull
    public RequirementEnergy provideComponent(MachineComponent.IOType machineIoType, JsonObject requirement) {
        if (!(requirement.has("energyPerTick") && requirement.get("energyPerTick").isJsonPrimitive() && requirement.get("energyPerTick").getAsJsonPrimitive().isNumber())) {
            throw new JsonParseException("The ComponentType 'energy' expects an 'energyPerTick'-entry that defines the amount of energy per tick!");
        }
        int energyPerTick = requirement.getAsJsonPrimitive("energyPerTick").getAsInt();
        return new RequirementEnergy(machineIoType, energyPerTick);
    }
}

