/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.tiles;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.lib.BlocksMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntityRestrictedTick;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.nbt.NBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileMachineController
extends TileEntityRestrictedTick {
    public static final int BLUEPRINT_SLOT = 0;
    public static final int ACCELERATOR_SLOT = 1;
    private CraftingStatus craftingStatus = CraftingStatus.MISSING_STRUCTURE;
    private DynamicMachine foundMachine = null;
    private BlockArray foundPattern = null;
    private EnumFacing patternRotation = null;
    private IOInventory inventory;
    private ActiveMachineRecipe activeRecipe = null;
    private List<MachineComponent> foundComponents = Lists.newArrayList();
    private Map<BlockPos, List<ModifierReplacement>> foundModifiers = new HashMap<BlockPos, List<ModifierReplacement>>();

    public TileMachineController() {
        this.inventory = this.buildInventory();
        this.inventory.setStackLimit(1, 0);
    }

    private IOInventory buildInventory() {
        return new IOInventory(this, new int[0], new int[0]).setMiscSlots(0, 1);
    }

    public IOInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void doRestrictedTick() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.func_145831_w().func_175676_y(this.func_174877_v()) > 0) {
                return;
            }
            this.checkStructure();
            this.updateComponents();
            if (this.foundMachine != null && this.foundPattern != null && this.patternRotation != null) {
                if (this.activeRecipe == null) {
                    if (this.ticksExisted % 80 == 0) {
                        this.searchMatchingRecipe();
                        this.craftingStatus = this.activeRecipe == null ? CraftingStatus.NO_RECIPE : CraftingStatus.CRAFTING;
                        this.markForUpdate();
                    }
                } else {
                    RecipeCraftingContext context = this.foundMachine.createContext(this.activeRecipe.getRecipe(), this.foundComponents, MiscUtils.flatten(this.foundModifiers.values()));
                    this.craftingStatus = this.activeRecipe.tick(context);
                    if (this.activeRecipe.isCompleted(this, context)) {
                        this.activeRecipe.complete(context);
                        this.activeRecipe.reset();
                        context = this.foundMachine.createContext(this.activeRecipe.getRecipe(), this.foundComponents, MiscUtils.flatten(this.foundModifiers.values()));
                        ComponentRequirement.CraftCheck result = context.canStartCrafting();
                        switch (result) {
                            case SUCCESS: {
                                context.startCrafting();
                                this.craftingStatus = CraftingStatus.CRAFTING;
                                break;
                            }
                            case FAILURE_MISSING_INPUT: {
                                this.activeRecipe = null;
                                this.searchMatchingRecipe();
                                this.craftingStatus = this.activeRecipe == null ? CraftingStatus.NO_RECIPE : CraftingStatus.CRAFTING;
                            }
                        }
                    }
                    this.markForUpdate();
                }
            } else {
                this.craftingStatus = CraftingStatus.MISSING_STRUCTURE;
                this.markForUpdate();
            }
        }
    }

    private void searchMatchingRecipe() {
        Iterable<MachineRecipe> availableRecipes = RecipeRegistry.getRegistry().getRecipesFor(this.foundMachine);
        for (MachineRecipe recipe : availableRecipes) {
            RecipeCraftingContext context = this.foundMachine.createContext(recipe, this.foundComponents, MiscUtils.flatten(this.foundModifiers.values()));
            if (context.canStartCrafting() != ComponentRequirement.CraftCheck.SUCCESS) continue;
            this.activeRecipe = new ActiveMachineRecipe(recipe);
            context.startCrafting();
            return;
        }
    }

    private void checkStructure() {
        block6: {
            block7: {
                if (this.ticksExisted % 20 != 0) break block6;
                if (this.foundMachine != null && this.foundPattern != null && this.patternRotation != null) {
                    if (this.foundMachine.requiresBlueprint() && !this.foundMachine.equals(this.getBlueprintMachine())) {
                        this.activeRecipe = null;
                        this.foundMachine = null;
                        this.foundPattern = null;
                        this.patternRotation = null;
                        this.craftingStatus = CraftingStatus.MISSING_STRUCTURE;
                        this.markForUpdate();
                    } else if (!this.foundPattern.matches(this.func_145831_w(), this.func_174877_v(), true, this.foundMachine.getModifiersAsMatchingReplacements())) {
                        this.activeRecipe = null;
                        this.foundMachine = null;
                        this.foundPattern = null;
                        this.patternRotation = null;
                        this.craftingStatus = CraftingStatus.MISSING_STRUCTURE;
                        this.markForUpdate();
                    }
                }
                if (this.foundMachine != null && this.foundPattern != null && this.patternRotation != null) break block6;
                this.foundMachine = null;
                this.foundPattern = null;
                this.patternRotation = null;
                DynamicMachine blueprint = this.getBlueprintMachine();
                if (blueprint == null) break block7;
                Tuple<EnumFacing, BlockArray> res = this.matchesRotation(blueprint.getPattern(), blueprint);
                if (res == null) break block6;
                this.foundMachine = blueprint;
                this.foundPattern = (BlockArray)res.func_76340_b();
                this.patternRotation = (EnumFacing)res.func_76341_a();
                this.field_145850_b.func_175656_a(this.field_174879_c, BlocksMM.blockController.func_176223_P().func_177226_a(BlockController.FACING, (Comparable)res.func_76341_a()));
                this.markForUpdate();
                if (this.foundMachine.getMachineColor() != Config.machineColor) {
                    this.distributeCasingColor();
                }
                break block6;
            }
            for (DynamicMachine machine : MachineRegistry.getRegistry()) {
                Tuple<EnumFacing, BlockArray> res;
                if (machine.requiresBlueprint() || (res = this.matchesRotation(machine.getPattern(), machine)) == null) continue;
                this.foundMachine = machine;
                this.foundPattern = (BlockArray)res.func_76340_b();
                this.patternRotation = (EnumFacing)res.func_76341_a();
                this.field_145850_b.func_175656_a(this.field_174879_c, BlocksMM.blockController.func_176223_P().func_177226_a(BlockController.FACING, (Comparable)res.func_76341_a()));
                this.markForUpdate();
                if (this.foundMachine.getMachineColor() == Config.machineColor) break;
                this.distributeCasingColor();
                break;
            }
        }
    }

    private void distributeCasingColor() {
        if (this.foundMachine != null && this.foundPattern != null) {
            int color = this.foundMachine.getMachineColor();
            this.tryColorize(this.func_174877_v(), color);
            for (BlockPos pos : this.foundPattern.getPattern().keySet()) {
                this.tryColorize(this.func_174877_v().func_177971_a((Vec3i)pos), color);
            }
        }
    }

    private void tryColorize(BlockPos pos, int color) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te != null && te instanceof TileColorableMachineComponent) {
            ((TileColorableMachineComponent)te).definedColor = color;
            ((TileColorableMachineComponent)te).markForUpdate();
            this.func_145831_w().func_175641_c(pos, this.func_145831_w().func_180495_p(pos).func_177230_c(), 1, 1);
        }
    }

    @Nullable
    public Tuple<EnumFacing, BlockArray> matchesRotation(BlockArray pattern, DynamicMachine machine) {
        EnumFacing face = EnumFacing.NORTH;
        do {
            if (pattern.matches(this.func_145831_w(), this.func_174877_v(), false, machine.getModifiersAsMatchingReplacements())) {
                return new Tuple((Object)face, (Object)pattern);
            }
            face = face.func_176735_f();
            pattern = pattern.rotateYCCW();
        } while (face != EnumFacing.NORTH);
        return null;
    }

    private void updateComponents() {
        if (this.foundMachine == null || this.foundPattern == null || this.patternRotation == null) {
            this.foundComponents.clear();
            this.foundModifiers.clear();
            this.foundMachine = null;
            this.foundPattern = null;
            this.patternRotation = null;
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.foundComponents = Lists.newArrayList();
            for (BlockPos potentialPosition : this.foundPattern.getPattern().keySet()) {
                MachineComponent component;
                BlockPos realPos = this.func_174877_v().func_177971_a((Vec3i)potentialPosition);
                TileEntity te = this.func_145831_w().func_175625_s(realPos);
                if (te == null || !(te instanceof MachineComponentTile) || (component = ((MachineComponentTile)te).provideComponent()) == null) continue;
                this.foundComponents.add(component);
            }
            int rotations = 0;
            EnumFacing rot = EnumFacing.NORTH;
            while (rot != this.patternRotation) {
                rot = rot.func_176735_f();
                ++rotations;
            }
            this.foundModifiers = Maps.newHashMap();
            for (Map.Entry<BlockPos, List<ModifierReplacement>> offsetModifiers : this.foundMachine.getModifiers().entrySet()) {
                BlockPos at = offsetModifiers.getKey();
                for (int i = 0; i < rotations; ++i) {
                    at = new BlockPos(at.func_177952_p(), at.func_177956_o(), -at.func_177958_n());
                }
                BlockPos realAt = this.func_174877_v().func_177971_a((Vec3i)at);
                for (ModifierReplacement mod : offsetModifiers.getValue()) {
                    if (!mod.getBlockInformation().matches(this.field_145850_b, realAt, false)) continue;
                    this.foundModifiers.putIfAbsent(offsetModifiers.getKey(), Lists.newArrayList());
                    this.foundModifiers.get(offsetModifiers.getKey()).add(mod);
                }
            }
        }
    }

    public float getCurrentActiveRecipeProgress(float partial) {
        if (this.activeRecipe == null) {
            return 0.0f;
        }
        float tick = (float)this.activeRecipe.getTick() + partial;
        float maxTick = this.activeRecipe.getRecipe().getRecipeTotalTickTime();
        return MathHelper.func_76131_a((float)(tick / maxTick), (float)0.0f, (float)1.0f);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nullable
    public DynamicMachine getFoundMachine() {
        return this.foundMachine;
    }

    @Nullable
    public DynamicMachine getBlueprintMachine() {
        ItemStack blueprintSlotted = this.inventory.getStackInSlot(0);
        if (!blueprintSlotted.func_190926_b()) {
            return ItemBlueprint.getAssociatedMachine(blueprintSlotted);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public CraftingStatus getCraftingStatus() {
        return this.craftingStatus;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inventory = IOInventory.deserialize(this, compound.func_74775_l("items"));
        this.inventory.setStackLimit(1, 0);
        this.craftingStatus = CraftingStatus.values()[compound.func_74762_e("status")];
        if (compound.func_74764_b("machine") && compound.func_74764_b("rotation")) {
            ResourceLocation rl = new ResourceLocation(compound.func_74779_i("machine"));
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(rl);
            if (machine == null) {
                ModularMachinery.log.info("Couldn't find machine named " + rl.toString() + " for controller at " + this.func_174877_v().toString());
                this.foundMachine = null;
                this.foundPattern = null;
                this.patternRotation = null;
            } else {
                EnumFacing rot = EnumFacing.func_176731_b((int)compound.func_74762_e("rotation"));
                BlockArray pattern = machine.getPattern();
                for (EnumFacing offset = EnumFacing.NORTH; offset != rot; offset = offset.func_176746_e()) {
                    pattern = pattern.rotateYCCW();
                }
                this.patternRotation = rot;
                this.foundPattern = pattern;
                this.foundMachine = machine;
                if (compound.func_74764_b("modifierOffsets")) {
                    NBTTagList list = compound.func_150295_c("modifierOffsets", 10);
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound posTag = list.func_150305_b(i);
                        BlockPos modOffset = NBTUtil.func_186861_c((NBTTagCompound)posTag.func_74775_l("position"));
                        IBlockState state = NBTHelper.getBlockState(posTag, "state");
                        for (ModifierReplacement mod : this.foundMachine.getModifiers().getOrDefault(modOffset, Lists.newArrayList())) {
                            if (!mod.getBlockInformation().matchesState(state)) continue;
                            this.foundModifiers.putIfAbsent(modOffset, Lists.newArrayList());
                            this.foundModifiers.get(modOffset).add(mod);
                        }
                    }
                }
            }
        } else {
            this.foundMachine = null;
            this.foundPattern = null;
            this.patternRotation = null;
        }
        if (compound.func_74764_b("activeRecipe")) {
            NBTTagCompound tag = compound.func_74775_l("activeRecipe");
            ActiveMachineRecipe recipe = new ActiveMachineRecipe(tag);
            if (recipe.getRecipe() == null) {
                ModularMachinery.log.info("Couldn't find recipe named " + tag.func_74779_i("recipeName") + " for controller at " + this.func_174877_v().toString());
                this.activeRecipe = null;
            } else {
                this.activeRecipe = recipe;
            }
        } else {
            this.activeRecipe = null;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("items", (NBTBase)this.inventory.writeNBT());
        compound.func_74768_a("status", this.craftingStatus.ordinal());
        if (this.foundMachine != null && this.patternRotation != null) {
            compound.func_74778_a("machine", this.foundMachine.getRegistryName().toString());
            compound.func_74768_a("rotation", this.patternRotation.func_176736_b());
            NBTTagList listModifierOffsets = new NBTTagList();
            for (BlockPos offset : this.foundModifiers.keySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)offset));
                NBTHelper.setBlockState(tag, "state", this.field_145850_b.func_180495_p(this.func_174877_v().func_177971_a((Vec3i)offset)));
                listModifierOffsets.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a("modifierOffsets", (NBTBase)listModifierOffsets);
        }
        if (this.activeRecipe != null) {
            compound.func_74782_a("activeRecipe", (NBTBase)this.activeRecipe.serialize());
        }
    }

    public static enum CraftingStatus {
        MISSING_STRUCTURE,
        NO_RECIPE,
        CRAFTING;

    }
}

