/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.block.BlockEnderUtilitiesPortal;
import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.item.ItemMobHarness;
import fi.dy.masa.enderutilities.item.base.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private static TickHandler instance;
    private Set<UUID> portalFlags = new HashSet<UUID>();
    private int serverTickCounter;
    private int playerTickCounter;

    public TickHandler() {
        instance = this;
    }

    public static TickHandler instance() {
        return instance;
    }

    public void addPlayerToTeleport(EntityPlayer player) {
        this.portalFlags.add(player.func_110124_au());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (++this.serverTickCounter >= 20) {
            this.serverTickCounter = 0;
            ChunkLoading.getInstance().tickChunkTimeouts();
        }
        this.teleportPlayers();
        ++this.playerTickCounter;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.side == Side.CLIENT || player.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.playerTickCounter % 40 == 0) {
            TargetData target;
            NBTTagCompound nbt;
            ItemStack stack;
            if (player.func_184218_aH() && player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.MOB_HARNESS))) {
                ItemMobHarness.addAITask(player.func_184187_bx(), false);
            }
            if (!(stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IChunkLoadingItem.class)).func_190926_b() && (nbt = stack.func_77978_p()) != null && nbt.func_74767_n("ChunkLoadingRequired") && (target = stack.func_77973_b() instanceof IModular ? TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) : TargetData.getTargetFromItem(stack)) != null) {
                ChunkLoading.getInstance().refreshChunkTimeout(target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4);
            }
        }
        PlayerTaskScheduler.getInstance().runTasks(player.func_130014_f_(), player);
    }

    private void teleportPlayers() {
        PlayerList list = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        if (!this.portalFlags.isEmpty()) {
            block0: for (UUID uuid : this.portalFlags) {
                EntityPlayerMP player = list.func_177451_a(uuid);
                if (player == null) continue;
                World world = player.func_130014_f_();
                BlockPos pos = player.func_180425_c();
                for (int i = 0; i < 3; ++i) {
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == EnderUtilitiesBlocks.PORTAL && player.func_174813_aQ().func_72326_a(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos))) {
                        ((BlockEnderUtilitiesPortal)state.func_177230_c()).teleportEntity(world, pos, state, (Entity)player);
                        continue block0;
                    }
                    pos = pos.func_177984_a();
                }
            }
            this.portalFlags.clear();
        }
    }
}

