/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client.base;

import fi.dy.masa.enderutilities.gui.client.base.GuiArea;
import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class ScrollBar
extends GuiArea {
    private final int id;
    private final int u;
    private final int v;
    @Nullable
    private final ResourceLocation texture;
    private final GuiEnderUtilities parent;
    private int hoverOffsetU;
    private int hoverOffsetV;
    private int position;
    private boolean dragging;
    private int dragStartY;
    private int dragStartPosition;
    private int positionMax = 999;

    public ScrollBar(int id, int x, int y, int u, int v, int width, int height, int positions, GuiEnderUtilities parent) {
        this(id, x, y, u, v, width, height, positions, parent, null);
    }

    public ScrollBar(int id, int x, int y, int u, int v, int width, int height, int positions, GuiEnderUtilities parent, ResourceLocation texture) {
        super(x, y, width, height);
        this.id = id;
        this.u = u;
        this.v = v;
        this.positionMax = positions - 1;
        this.parent = parent;
        this.texture = texture;
        this.hoverOffsetU = width;
    }

    public ScrollBar setHoverOffsetU(int offsetU) {
        this.hoverOffsetU = offsetU;
        return this;
    }

    public ScrollBar setHoverOffsetV(int offsetV) {
        this.hoverOffsetV = offsetV;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public int getPosition() {
        return Math.min(this.position, this.positionMax);
    }

    public void setPositionCount(int count) {
        this.positionMax = Math.max(0, count - 1);
        if (this.position > this.positionMax) {
            this.position = this.positionMax;
        }
    }

    public int getMaxPosition() {
        return this.positionMax;
    }

    public void render(int parentX, int parentY, int mouseX, int mouseY) {
        if (this.texture != null) {
            this.parent.bindTexture(this.texture);
        }
        int x = parentX + this.getX();
        int y = parentY + this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int offsetU = 0;
        int offsetV = 0;
        if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y, w, w)) {
            offsetU = this.hoverOffsetU;
            offsetV = this.hoverOffsetV;
        }
        this.parent.func_73729_b(x, y, this.u + offsetU, this.v + offsetV, w, w);
        if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y + h - w, w, w)) {
            offsetU = this.hoverOffsetU;
            offsetV = this.hoverOffsetV;
        } else {
            offsetU = 0;
            offsetV = 0;
        }
        this.parent.func_73729_b(x, y + h - w, this.u + offsetU, this.v + offsetV + w, w, w);
        if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y + w, w, h - 2 * w)) {
            offsetU = this.hoverOffsetU;
            offsetV = this.hoverOffsetV;
        } else {
            offsetU = 0;
            offsetV = 0;
        }
        int offY = this.positionMax > 0 ? (h - 16 - 2 * w) * this.position / this.positionMax : 0;
        this.parent.func_73729_b(x, y + w + offY, this.u + offsetU, this.v + offsetV + 2 * w, w, h - 2 * w);
    }

    public boolean handleMouseInput(int mouseX, int mouseY) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int dWheel = Mouse.getEventDWheel();
        if (!Mouse.isButtonDown((int)0)) {
            this.dragging = false;
        }
        if (this.dragging) {
            int pos = this.dragStartPosition + this.positionMax * (mouseY - this.dragStartY) / (h - 16 - 2 * w);
            this.position = pos = MathHelper.func_76125_a((int)pos, (int)0, (int)this.positionMax);
            this.parent.scrollbarAction(this.id, ScrollbarAction.SET, pos);
            return true;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y, w, w)) {
                return this.move(-1, true);
            }
            if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y + h - w, w, w)) {
                return this.move(1, true);
            }
            if (ScrollBar.isMouseOverRegion(mouseX, mouseY, x, y + w, w, h - 2 * w)) {
                int pos = this.positionMax * (mouseY - y - w - 6) / (h - 16 - 2 * w);
                this.position = pos = MathHelper.func_76125_a((int)pos, (int)0, (int)this.positionMax);
                this.parent.scrollbarAction(this.id, ScrollbarAction.SET, pos);
                this.dragging = true;
                this.dragStartPosition = this.position;
                this.dragStartY = mouseY;
                return true;
            }
        } else if (dWheel != 0) {
            return this.move(dWheel < 0 ? 1 : -1, false);
        }
        return false;
    }

    private boolean move(int amount, boolean playSound) {
        this.position = MathHelper.func_76125_a((int)(this.position + amount), (int)0, (int)this.positionMax);
        this.parent.scrollbarAction(this.id, ScrollbarAction.MOVE, -1);
        if (playSound) {
            this.playPressSound();
        }
        return true;
    }

    protected void playPressSound() {
        this.parent.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static enum ScrollbarAction {
        MOVE,
        SET;

    }
}

