/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerCustomSlotClick;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModules;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotModuleModularItem;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncSlot;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;

public class ContainerPickupManager
extends ContainerLargeStacks
implements IContainerItem {
    public static final int NUM_MODULES = 4;
    public static final int NUM_LINK_CRYSTAL_SLOTS = 3;
    public InventoryItem inventoryItemTransmit;
    public InventoryItemModules inventoryItemModules;
    public InventoryItem inventoryItemFilters;
    protected UUID containerUUID;
    protected SlotRange filterSlots;
    private ItemStack stackLast = ItemStack.field_190927_a;

    public ContainerPickupManager(EntityPlayer player, ItemStack containerStack) {
        super(player, new InventoryItem(containerStack, 1, 1024, true, player.func_130014_f_().field_72995_K, "TransportItems"));
        this.containerUUID = NBTUtils.getUUIDFromItemStack(containerStack, "UUID", true);
        this.filterSlots = new SlotRange(0, 0);
        this.inventoryItemModules = new InventoryItemModules(containerStack, 4, player.func_130014_f_().field_72995_K);
        this.inventoryItemModules.setHostInventory((IItemHandler)this.playerInv, this.containerUUID);
        this.inventoryItemModules.readFromContainerItemStack();
        byte preset = NBTUtils.getByte(containerStack, "PickupManager", "SelPreset");
        this.inventoryItemFilters = new InventoryItem(containerStack, 36, 1, false, player.func_130014_f_().field_72995_K, "FilterItems_" + preset);
        this.inventoryItemFilters.setHostInventory((IItemHandler)this.playerInv, this.containerUUID);
        this.inventoryItemFilters.readFromContainerItemStack();
        this.inventoryItemTransmit = (InventoryItem)this.inventory;
        this.inventoryItemTransmit.setHostInventory((IItemHandler)this.playerInv, this.containerUUID);
        this.inventoryItemTransmit.readFromContainerItemStack();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 174);
    }

    @Override
    protected void addCustomInventorySlots() {
        int first;
        int j;
        int i;
        int start = this.field_75151_b.size();
        int posX = 8;
        int posY = 29;
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventoryItemTransmit, 0, 89, posY));
        this.customInventorySlots = new MergeSlotRange(start, 1);
        start = this.field_75151_b.size();
        posY = 47;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventoryItemFilters, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        posY = 123;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventoryItemFilters, i * 9 + j + 18, posX + j * 18, posY + i * 18));
            }
        }
        this.filterSlots = new SlotRange(start, 36);
        posX = 116;
        posY = 29;
        start = this.field_75151_b.size();
        int slot = first = UtilItemModular.getFirstIndexOfModuleType(this.inventoryItemModules.getContainerItemStack(), ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.func_75146_a((Slot)new SlotModuleModularItem(this.inventoryItemModules, slot, posX + i2 * 18, posY, ItemModule.ModuleType.TYPE_LINKCRYSTAL, this));
            ++slot;
        }
        this.addMergeSlotRangePlayerToExt(start, 3);
    }

    @Override
    public ItemStack getContainerItem() {
        return InventoryUtils.getItemStackByUUID((IItemHandler)this.playerInv, this.containerUUID, "UUID");
    }

    protected boolean fakeSlotClick(int slotNum, int button, ClickType clickType, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = player.field_71071_by.func_70445_o();
        if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || button != 0 && button != 1)) {
            if (slot == null || slot.getItemHandler() != this.inventoryItemFilters) {
                return false;
            }
            if (!stackCursor.func_190926_b()) {
                ItemStack stackTmp = stackCursor.func_77946_l();
                stackTmp.func_190920_e(1);
                slot.func_75215_d(stackTmp);
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return true;
        }
        if (this.isDragging) {
            if (clickType == ClickType.QUICK_CRAFT && (button == 2 || button == 6)) {
                if (!stackCursor.func_190926_b()) {
                    ItemStack stackTmp = stackCursor.func_77946_l();
                    stackTmp.func_190920_e(1);
                    Iterator iterator = this.draggedSlots.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        SlotItemHandlerGeneric slotTmp = this.getSlotItemHandler(i);
                        if (slotTmp == null || slotTmp.getItemHandler() != this.inventoryItemFilters) continue;
                        slotTmp.func_75215_d(stackTmp.func_77946_l());
                    }
                }
                this.isDragging = false;
            } else if (clickType == ClickType.QUICK_CRAFT && (button == 1 || button == 5)) {
                this.dragging(slotNum);
            }
        } else if (clickType == ClickType.QUICK_CRAFT && (button == 0 || button == 4)) {
            this.isDragging = true;
            this.dragType = button == 4 ? ContainerCustomSlotClick.DragType.DRAG_RIGHT : ContainerCustomSlotClick.DragType.DRAG_LEFT;
            this.draggedSlots.clear();
        }
        return false;
    }

    @Override
    public void func_75142_b() {
        ItemStack stack;
        if (!this.player.func_130014_f_().field_72995_K && (stack = this.getContainerItem()) != this.stackLast) {
            this.inventoryItemTransmit.readFromContainerItemStack();
            this.inventoryItemModules.readFromContainerItemStack();
            this.inventoryItemFilters.readFromContainerItemStack();
            this.stackLast = stack;
        }
        super.func_75142_b();
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        boolean sent;
        if (this.filterSlots.contains(slotNum)) {
            this.fakeSlotClick(slotNum, dragType, clickType, player);
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.QUICK_CRAFT && slotNum == -999) {
            Iterator iterator = this.draggedSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (!this.filterSlots.contains(i)) continue;
                this.fakeSlotClick(i, dragType, clickType, player);
                return ItemStack.field_190927_a;
            }
        }
        ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
        ItemStack modularStackPost = this.getContainerItem();
        if (!player.func_130014_f_().field_72995_K && !modularStackPost.func_190926_b() && modularStackPost.func_77973_b() == EnderUtilitiesItems.PICKUP_MANAGER && (sent = ((ItemPickupManager)modularStackPost.func_77973_b()).tryTransportItemsFromTransportSlot(this.inventoryItemTransmit, player, modularStackPost)) && player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncSlot(this.field_75152_c, 0, this.func_75139_a(0).func_75211_c()), (EntityPlayerMP)player);
        }
        this.func_75142_b();
        return stack;
    }
}

