/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.base.ContainerCustomSlotClick;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerTile;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityQuickStackerAdvanced;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerQuickStackerAdvanced
extends ContainerTile {
    private final TileEntityQuickStackerAdvanced teqsa;
    private final IItemHandler inventoryFilters;
    private SlotRange filterSlots = new SlotRange(0, 0);
    protected short[] valuesLast = new short[4];
    protected long enabledSlotsMask;

    public ContainerQuickStackerAdvanced(EntityPlayer player, TileEntityQuickStackerAdvanced te) {
        super(player, te);
        this.teqsa = te;
        this.inventoryFilters = te.getFilterInventory();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(23, 174);
        this.addOffhandSlot(5, 156);
    }

    @Override
    protected void addCustomInventorySlots() {
        int slot;
        int posX = 23;
        int posY = 17;
        posX = 23;
        posY = 17;
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), this.inventory.getSlots());
        for (slot = 0; slot < 9; ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerModule(this.inventory, slot, posX + slot * 18, posY, ItemModule.ModuleType.TYPE_LINKCRYSTAL));
        }
        posY = 35;
        for (slot = 0; slot < 9; ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerModule(this.inventory, slot + 9, posX + slot * 18, posY, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC));
        }
        this.filterSlots = new SlotRange(this.field_75151_b.size(), this.inventoryFilters.getSlots());
        posY = 83;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventoryFilters, row * 9 + column, posX + column * 18, posY + row * 18));
            }
        }
    }

    protected boolean fakeSlotClick(int slotNum, int button, ClickType clickType, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = player.field_71071_by.func_70445_o();
        if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || button != 0 && button != 1)) {
            if (slot == null || slot.getItemHandler() != this.inventoryFilters || !this.teqsa.isInventoryAccessible(player)) {
                return false;
            }
            if (!stackCursor.func_190926_b()) {
                ItemStack stackTmp = stackCursor.func_77946_l();
                stackTmp.func_190920_e(1);
                slot.func_75215_d(stackTmp);
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else if (this.isDragging) {
            if (clickType == ClickType.QUICK_CRAFT && (button == 2 || button == 6)) {
                if (!stackCursor.func_190926_b()) {
                    ItemStack stackTmp = stackCursor.func_77946_l();
                    stackTmp.func_190920_e(1);
                    Iterator iterator = this.draggedSlots.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        SlotItemHandlerGeneric slotTmp = this.getSlotItemHandler(i);
                        if (slotTmp == null || slotTmp.getItemHandler() != this.inventoryFilters || !this.teqsa.isInventoryAccessible(player)) continue;
                        slotTmp.func_75215_d(stackTmp.func_77946_l());
                    }
                }
                this.isDragging = false;
            } else if (clickType == ClickType.QUICK_CRAFT && (button == 1 || button == 5)) {
                this.dragging(slotNum);
            }
        } else if (clickType == ClickType.QUICK_CRAFT && (button == 0 || button == 4)) {
            this.isDragging = true;
            this.dragType = button == 4 ? ContainerCustomSlotClick.DragType.DRAG_RIGHT : ContainerCustomSlotClick.DragType.DRAG_LEFT;
            this.draggedSlots.clear();
        }
        if (player instanceof EntityPlayerMP) {
            this.func_75142_b();
        }
        return false;
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (this.filterSlots.contains(slotNum)) {
            this.fakeSlotClick(slotNum, dragType, clickType, player);
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.QUICK_CRAFT && slotNum == -999) {
            Iterator iterator = this.draggedSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (!this.filterSlots.contains(i)) continue;
                this.fakeSlotClick(i, dragType, clickType, player);
                return ItemStack.field_190927_a;
            }
        } else if (clickType == ClickType.CLONE && dragType == 2) {
            int invSlotNum;
            int n = invSlotNum = this.func_75139_a(slotNum) != null ? this.func_75139_a(slotNum).getSlotIndex() : -1;
            if (invSlotNum == -1 || invSlotNum >= 36 && invSlotNum != 40) {
                return ItemStack.field_190927_a;
            }
            long mask = this.teqsa.getEnabledSlotsMask();
            this.teqsa.setEnabledSlotsMask(mask ^= 1L << invSlotNum);
            return ItemStack.field_190927_a;
        }
        ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
        if (player instanceof EntityPlayerMP) {
            this.func_75142_b();
        }
        return stack;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.teqsa.isAreaMode() ? 1 : 0);
        listener.func_71112_a((Container)this, 1, (int)this.teqsa.getAreaModeSettings());
        listener.func_71112_a((Container)this, 2, (int)this.teqsa.getEnabledTargetsMask());
        listener.func_71112_a((Container)this, 3, (int)this.teqsa.getSelectedTarget());
        long mask = this.teqsa.getEnabledSlotsMask();
        listener.func_71112_a((Container)this, 4, (int)((short)(mask >>> 32 & 0xFFFFL)));
        listener.func_71112_a((Container)this, 5, (int)((short)(mask >>> 16 & 0xFFFFL)));
        listener.func_71112_a((Container)this, 6, (int)((short)(mask & 0xFFFFL)));
    }

    @Override
    public void func_75142_b() {
        short areaMode = this.teqsa.isAreaMode() ? (short)1 : 0;
        long mask = this.teqsa.getEnabledSlotsMask();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            if (areaMode != this.valuesLast[0]) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, (int)areaMode);
            }
            if (this.teqsa.getAreaModeSettings() != this.valuesLast[1]) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, (int)this.teqsa.getAreaModeSettings());
            }
            if (this.teqsa.getEnabledTargetsMask() != this.valuesLast[2]) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 2, (int)this.teqsa.getEnabledTargetsMask());
            }
            if (this.teqsa.getSelectedTarget() != this.valuesLast[3]) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 3, (int)this.teqsa.getSelectedTarget());
            }
            if (mask == this.enabledSlotsMask) continue;
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 4, (int)((short)(mask >>> 32 & 0xFFFFL)));
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 5, (int)((short)(mask >>> 16 & 0xFFFFL)));
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 6, (int)((short)(mask & 0xFFFFL)));
        }
        this.valuesLast[0] = areaMode;
        this.valuesLast[1] = this.teqsa.getAreaModeSettings();
        this.valuesLast[2] = this.teqsa.getEnabledTargetsMask();
        this.valuesLast[3] = this.teqsa.getSelectedTarget();
        this.enabledSlotsMask = mask;
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        switch (id) {
            case 0: {
                this.teqsa.setIsAreaMode(data != 0);
                break;
            }
            case 1: {
                this.teqsa.setAreaModeSettings((byte)data);
                break;
            }
            case 2: {
                this.teqsa.setEnabledTargetsMask((short)data);
                break;
            }
            case 3: {
                this.teqsa.setSelectedTarget((byte)data);
                break;
            }
            case 4: {
                this.enabledSlotsMask = (long)data << 32 & 0xFFFF00000000L;
                break;
            }
            case 5: {
                this.enabledSlotsMask |= (long)data << 16 & 0xFFFF0000L;
                break;
            }
            case 6: {
                this.enabledSlotsMask |= (long)data & 0xFFFFL;
                this.teqsa.setEnabledSlotsMask(this.enabledSlotsMask);
                break;
            }
        }
    }
}

