/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.entity.EntityChair;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemChairWand
extends ItemEnderUtilities
implements IKeyBound {
    public ItemChairWand(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            float yOffset = player.func_70093_af() ? -hitY : 0.0f;
            EntityChair chair = new EntityChair(worldIn);
            chair.setWidth(this.getEntityWidth(stack));
            chair.setHeight(this.getEntityHeight(stack));
            chair.func_70107_b((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY + yOffset, (float)pos.func_177952_p() + hitZ);
            worldIn.func_72838_d((Entity)chair);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.func_130014_f_().field_72995_K && entity instanceof EntityChair) {
            entity.func_70106_y();
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private float getEntityWidth(ItemStack stack) {
        byte value = NBTUtils.getByte(stack, "Chair", "Width");
        return value == 0 ? 0.5f : (float)value / 16.0f;
    }

    private float getEntityHeight(ItemStack stack) {
        byte value = NBTUtils.getByte(stack, "Chair", "Height");
        return value == 0 ? 0.75f : (float)value / 16.0f;
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = this.getBaseItemDisplayName(stack);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            float width = this.getEntityWidth(stack);
            float height = this.getEntityHeight(stack);
            itemName = String.format("%s - w: %.3f, h: %.3f", itemName, Float.valueOf(width), Float.valueOf(height));
        }
        return itemName;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            NBTUtils.cycleByteValue(stack, "Chair", "Width", 1, 64, !HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.SCROLL.matches(key, 262144)) {
            NBTUtils.cycleByteValue(stack, "Chair", "Height", 1, 64, !HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        return false;
    }
}

