/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiSoundBlock;
import fi.dy.masa.enderutilities.inventory.container.ContainerSoundBlock;
import fi.dy.masa.enderutilities.network.message.ISyncableTile;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.network.message.MessageSyncTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntitySoundBlock
extends TileEntityEnderUtilities
implements ISyncableTile {
    private String soundName;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private boolean repeat;
    private boolean redstoneState;
    public String filter = "";
    public int selectedSound = -1;

    public TileEntitySoundBlock() {
        super("sound_block");
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setVolume(float volume) {
        this.volume = MathHelper.func_76131_a((float)volume, (float)0.0f, (float)4.0f);
    }

    public void setPitch(float pitch) {
        this.pitch = MathHelper.func_76131_a((float)pitch, (float)0.0f, (float)20.0f);
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("Sound", 8)) {
            this.soundName = nbt.func_74779_i("Sound");
        }
        this.redstoneState = nbt.func_74767_n("Powered");
        this.repeat = nbt.func_74767_n("Repeat");
        this.volume = nbt.func_74760_g("Volume");
        this.pitch = nbt.func_74760_g("Pitch");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.soundName != null) {
            nbt.func_74778_a("Sound", this.soundName);
        }
        nbt.func_74776_a("Volume", this.volume);
        nbt.func_74776_a("Pitch", this.pitch);
        nbt.func_74757_a("Repeat", this.repeat);
        nbt.func_74757_a("Powered", this.redstoneState);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74768_a("sb1", this.getPitchVolumeForSync());
        boolean play = this.func_145831_w() != null && this.func_145831_w().func_175640_z(this.func_174877_v());
        nbt.func_74768_a("sb2", this.getRepeatAndSoundIdForSync(play));
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.syncTile(new int[]{tag.func_74762_e("sb1"), tag.func_74762_e("sb2")}, null);
    }

    public void sendPlaySoundPacket(boolean stop) {
        SoundEvent sound;
        if (this.soundName != null && (sound = this.getSound()) != null) {
            int id = SoundEvent.field_187505_a.func_148757_b((Object)sound);
            float x = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float y = (float)this.func_174877_v().func_177956_o() + 0.5f;
            float z = (float)this.func_174877_v().func_177952_p() + 0.5f;
            MessageAddEffects message = new MessageAddEffects(id, this.pitch, this.volume, this.repeat, stop, x, y, z);
            this.sendPacketToWatchers(message);
        }
    }

    private void playOrStopSound(boolean stop) {
        SoundEvent sound = this.getSound();
        if (sound != null) {
            int id = SoundEvent.field_187505_a.func_148757_b((Object)sound);
            float x = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float y = (float)this.func_174877_v().func_177956_o() + 0.5f;
            float z = (float)this.func_174877_v().func_177952_p() + 0.5f;
            EnderUtilities.proxy.playSound(id, this.pitch, this.volume, this.repeat, stop, x, y, z);
        }
    }

    @Nullable
    private SoundEvent getSound() {
        return this.soundName != null ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(this.soundName)) : null;
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        this.sendPlaySoundPacket(true);
        this.sendPlaySoundPacket(false);
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block blockIn) {
        boolean powered = this.func_145831_w().func_175640_z(this.func_174877_v());
        if (powered != this.redstoneState) {
            if (powered) {
                this.sendPlaySoundPacket(true);
                this.sendPlaySoundPacket(false);
            }
            this.redstoneState = powered;
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        switch (action) {
            case 0: {
                this.repeat = !this.repeat;
                break;
            }
            case 1: {
                this.setPitch(this.pitch + (float)element / 1000.0f);
                break;
            }
            case 2: {
                this.setVolume(this.volume + (float)element / 1000.0f);
                break;
            }
            case 10: {
                this.sendPlaySoundPacket(false);
                return;
            }
            case 11: {
                this.sendPlaySoundPacket(true);
                return;
            }
            case 1000: {
                this.sendPlaySoundPacket(true);
                this.setSoundFromID(element);
            }
        }
        this.func_70296_d();
        this.sendSyncPacket(action == 1000);
    }

    private int getPitchVolumeForSync() {
        return (int)(this.volume * 1000.0f) << 16 | (int)(this.pitch * 1000.0f);
    }

    private int getRepeatAndSoundIdForSync(boolean playNow) {
        int value;
        int n = value = this.repeat ? Integer.MIN_VALUE : 0;
        if (this.soundName != null) {
            SoundEvent sound = this.getSound();
            value = sound != null ? (value |= SoundEvent.field_187505_a.func_148757_b((Object)sound)) : (value |= 0xFFFF);
            if (playNow) {
                value |= 0x40000000;
            }
        }
        return value;
    }

    private void sendSyncPacket(boolean playNow) {
        int value0 = this.getPitchVolumeForSync();
        int value1 = this.getRepeatAndSoundIdForSync(playNow);
        this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), value0, value1));
    }

    @Override
    public void syncTile(int[] values, ItemStack[] stacks) {
        if (values.length == 1) {
            this.playOrStopSound(false);
        } else if (values.length == 2) {
            this.setPitchAndVolume(values[0]);
            this.setSoundAndRepeat(values[1]);
            if ((values[1] & 0x40000000) != 0) {
                this.playOrStopSound(false);
            }
        }
    }

    private void setPitchAndVolume(int value) {
        this.pitch = (float)(value & 0xFFFF) / 1000.0f;
        this.volume = (float)(value >>> 16) / 1000.0f;
    }

    private void setSoundAndRepeat(int value) {
        this.setSoundFromID((short)(value & 0xFFFF));
        this.repeat = (value & Integer.MIN_VALUE) != 0;
    }

    private void setSoundFromID(int id) {
        SoundEvent sound;
        this.selectedSound = id;
        this.soundName = id >= 0 ? ((sound = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(id)) != null ? sound.getRegistryName().toString() : null) : null;
    }

    @Override
    public ContainerSoundBlock getContainer(EntityPlayer player) {
        return new ContainerSoundBlock(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiSoundBlock(this.getContainer(player), this);
    }
}

