/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ChunkLoading
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static ChunkLoading instance;
    private Map<String, DimChunkCoordTimeout> timeOuts;
    private SetMultimap<String, ForgeChunkManager.Ticket> playerTickets;
    private SetMultimap<World, ForgeChunkManager.Ticket> modTickets;

    public ChunkLoading() {
        instance = this;
        this.init();
    }

    public static ChunkLoading getInstance() {
        return instance;
    }

    public void init() {
        this.timeOuts = new HashMap<String, DimChunkCoordTimeout>();
        this.playerTickets = HashMultimap.create();
        this.modTickets = HashMultimap.create();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket == null) continue;
            for (ChunkPos chunk : ticket.getChunkList()) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
            }
        }
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        HashSet<ForgeChunkManager.Ticket> persistentTickets = new HashSet<ForgeChunkManager.Ticket>();
        LinkedList<ForgeChunkManager.Ticket> claimedTickets = new LinkedList<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound nbt;
            if (ticket == null || (nbt = ticket.getModData()) == null || !nbt.func_74767_n("Persistent")) continue;
            persistentTickets.add(ticket);
        }
        claimedTickets.addAll(persistentTickets);
        return claimedTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        HashMultimap persistentPlayerTickets = HashMultimap.create();
        LinkedListMultimap claimedTickets = LinkedListMultimap.create();
        for (String player : tickets.keys()) {
            for (ForgeChunkManager.Ticket ticket : tickets.get((Object)player)) {
                NBTTagCompound nbt;
                if (ticket == null || (nbt = ticket.getModData()) == null || !nbt.func_74767_n("Persistent")) continue;
                persistentPlayerTickets.put((Object)player, (Object)ticket);
            }
        }
        claimedTickets.putAll((Multimap)persistentPlayerTickets);
        return claimedTickets;
    }

    public ForgeChunkManager.Ticket requestPlayerTicket(EntityPlayer player, int dimension, boolean isTemporary) {
        for (ForgeChunkManager.Ticket ticket : this.playerTickets.get((Object)(player.func_110124_au().toString() + "-" + dimension))) {
            if (ticket != null && ticket.getChunkList() != null && ticket.getChunkList().size() < ticket.getChunkListDepth()) {
                return ticket;
            }
            if (ticket == null || ticket.getChunkList() != null) continue;
            EnderUtilities.logger.warn("requestPlayerTicket(): ticket.getChunkList() == null");
        }
        MinecraftServer srv = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (srv == null) {
            EnderUtilities.logger.warn("requestPlayerTicket(): Couldn't get the MinecraftServer instance");
            return null;
        }
        WorldServer world = srv.func_71218_a(dimension);
        if (world == null) {
            EnderUtilities.logger.warn("requestPlayerTicket(): Couldn't get world for dimension (" + dimension + ")");
            return null;
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestPlayerTicket((Object)EnderUtilities.instance, (String)player.func_70005_c_(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            EnderUtilities.logger.warn("requestPlayerTicket(): Couldn't get a chunk loading ticket for player '" + player.func_70005_c_() + "'");
            return null;
        }
        NBTTagCompound nbt = ticket.getModData();
        OwnerData.writeOwnerTagToNBT(nbt, (Entity)player);
        if (!isTemporary) {
            nbt.func_74757_a("Persistent", true);
        }
        this.playerTickets.get((Object)(player.func_110124_au().toString() + "-" + dimension)).add(ticket);
        return ticket;
    }

    public ForgeChunkManager.Ticket requestModTicket(int dimension, boolean isTemporary) {
        MinecraftServer srv = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (srv == null) {
            EnderUtilities.logger.warn("requestModTicket(): Couldn't get the MinecraftServer instance");
            return null;
        }
        WorldServer world = srv.func_71218_a(dimension);
        if (world == null) {
            EnderUtilities.logger.warn("requestModTicket(): Couldn't get world for dimension (" + dimension + ")");
            return null;
        }
        for (ForgeChunkManager.Ticket ticket : this.modTickets.get((Object)world)) {
            if (ticket != null && ticket.getChunkList() != null && ticket.getChunkList().size() < ticket.getChunkListDepth()) {
                return ticket;
            }
            if (ticket == null || ticket.getChunkList() != null) continue;
            EnderUtilities.logger.warn("requestModTicket(): ticket.getChunkList() == null");
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)EnderUtilities.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            EnderUtilities.logger.warn("requestModTicket(): Couldn't get a mod chunk loading ticket");
            return null;
        }
        if (!isTemporary) {
            NBTTagCompound nbt = ticket.getModData();
            nbt.func_74757_a("Persistent", true);
        }
        this.modTickets.get((Object)world).add(ticket);
        return ticket;
    }

    public UUID getPlayerUUIDFromTicket(ForgeChunkManager.Ticket ticket) {
        if (ticket == null) {
            return null;
        }
        OwnerData playerData = OwnerData.getOwnerDataFromNBT(ticket.getModData());
        if (playerData != null) {
            return playerData.getOwnerUUID();
        }
        return null;
    }

    public void removeTicket(ForgeChunkManager.Ticket ticket) {
        if (ticket == null || ticket.world == null) {
            return;
        }
        if (ticket.isPlayerTicket()) {
            UUID uuid = this.getPlayerUUIDFromTicket(ticket);
            if (ticket.world.field_73011_w != null && uuid != null) {
                this.playerTickets.get((Object)(uuid.toString() + "-" + ticket.world.field_73011_w.getDimension())).remove(ticket);
            }
        } else {
            this.modTickets.get((Object)ticket.world).remove(ticket);
        }
    }

    public static String dimChunkCoordsToString(int dim, int x, int z) {
        return dim + "_" + x + "_" + z;
    }

    public boolean loadChunkWithoutForce(int dimension, int chunkX, int chunkZ) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return false;
        }
        return this.loadChunkWithoutForce(server.func_71218_a(dimension), chunkX, chunkZ);
    }

    public boolean loadChunkWithoutForce(WorldServer worldServer, int chunkX, int chunkZ) {
        if (worldServer == null || worldServer.func_72863_F() == null) {
            return false;
        }
        if (!worldServer.func_72863_F().func_73149_a(chunkX, chunkZ)) {
            worldServer.func_72863_F().func_186028_c(chunkX, chunkZ);
        }
        return true;
    }

    public boolean loadChunkForcedWithPlayerTicket(EntityPlayer player, int dimension, int chunkX, int chunkZ, int unloadDelay) {
        if (this.hasChunkTimeout(dimension, chunkX, chunkZ) && this.refreshChunkTimeout(dimension, chunkX, chunkZ, unloadDelay, true)) {
            return true;
        }
        ForgeChunkManager.Ticket ticket = this.requestPlayerTicket(player, dimension, unloadDelay != 0);
        return this.loadChunkForcedWithTicket(ticket, dimension, chunkX, chunkZ, unloadDelay);
    }

    public boolean loadChunkForcedWithModTicket(int dimension, int chunkX, int chunkZ, int unloadDelay) {
        if (this.hasChunkTimeout(dimension, chunkX, chunkZ) && this.refreshChunkTimeout(dimension, chunkX, chunkZ, unloadDelay, true)) {
            return true;
        }
        ForgeChunkManager.Ticket ticket = this.requestModTicket(dimension, unloadDelay != 0);
        return this.loadChunkForcedWithTicket(ticket, dimension, chunkX, chunkZ, unloadDelay);
    }

    public boolean loadChunkForcedWithTicket(ForgeChunkManager.Ticket ticket, int dimension, int chunkX, int chunkZ, int unloadDelay) {
        if (ticket == null) {
            EnderUtilities.logger.warn("loadChunkForcedWithTicket(): ticket == null");
            return false;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(chunkX, chunkZ));
        if (unloadDelay > 0) {
            this.addChunkTimeout(ticket, dimension, chunkX, chunkZ, unloadDelay);
        }
        return this.loadChunkWithoutForce(dimension, chunkX, chunkZ);
    }

    public boolean hasChunkTimeout(int dimension, int chunkX, int chunkZ) {
        return this.timeOuts.get(ChunkLoading.dimChunkCoordsToString(dimension, chunkX, chunkZ)) != null;
    }

    public void addChunkTimeout(ForgeChunkManager.Ticket ticket, int dimension, int chunkX, int chunkZ, int timeout) {
        String s = ChunkLoading.dimChunkCoordsToString(dimension, chunkX, chunkZ);
        DimChunkCoordTimeout dcct = this.timeOuts.get(s);
        if (dcct != null) {
            dcct.setTimeout(timeout);
        } else if (ticket != null) {
            this.timeOuts.put(s, new DimChunkCoordTimeout(ticket, dimension, new ChunkPos(chunkX, chunkZ), timeout));
        }
    }

    public boolean refreshChunkTimeout(int dimension, int chunkX, int chunkZ) {
        return this.refreshChunkTimeout(dimension, chunkX, chunkZ, -1, true);
    }

    public boolean refreshChunkTimeout(int dimension, int chunkX, int chunkZ, int timeout) {
        return this.refreshChunkTimeout(dimension, chunkX, chunkZ, timeout, true);
    }

    public boolean refreshChunkTimeout(int dimension, int chunkX, int chunkZ, int timeout, boolean increaseOnly) {
        String s = ChunkLoading.dimChunkCoordsToString(dimension, chunkX, chunkZ);
        DimChunkCoordTimeout dcct = this.timeOuts.get(s);
        if (dcct != null) {
            if (!(timeout < 0 || increaseOnly && timeout <= dcct.timeoutFresh)) {
                dcct.setTimeout(timeout);
            } else {
                dcct.refreshTimeout();
            }
            return true;
        }
        return false;
    }

    public void tickChunkTimeouts() {
        Iterator<Map.Entry<String, DimChunkCoordTimeout>> iterator = this.timeOuts.entrySet().iterator();
        while (iterator.hasNext()) {
            DimChunkCoordTimeout dcct = iterator.next().getValue();
            if (dcct != null && (this.playerTickets.containsValue((Object)dcct.ticket) || this.modTickets.containsValue((Object)dcct.ticket))) {
                if (dcct.tick() != 0) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)dcct.ticket, (ChunkPos)dcct.chunkCoords);
                if (dcct.ticket != null && dcct.ticket.getChunkList().size() == 0) {
                    this.removeTicket(dcct.ticket);
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)dcct.ticket);
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    public class DimChunkCoordTimeout {
        public int dimension;
        public ChunkPos chunkCoords;
        public int timeout;
        public int timeoutFresh;
        public ForgeChunkManager.Ticket ticket;

        public DimChunkCoordTimeout(ForgeChunkManager.Ticket ticket, int dimension, ChunkPos cc, int timeout) {
            this.ticket = ticket;
            this.dimension = dimension;
            this.chunkCoords = cc;
            this.timeout = timeout;
            this.timeoutFresh = timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
            this.timeoutFresh = timeout;
        }

        public void refreshTimeout() {
            this.timeout = this.timeoutFresh;
        }

        public int tick() {
            if (this.timeout > 0) {
                --this.timeout;
            }
            return this.timeout;
        }

        public String toString() {
            return this.dimension + "-" + this.chunkCoords.field_77276_a + "-" + this.chunkCoords.field_77275_b;
        }

        public boolean equals(DimChunkCoordTimeout dcct) {
            return this.dimension == dcct.dimension && this.chunkCoords.equals((Object)dcct.chunkCoords);
        }

        public boolean equals(int dim, ChunkPos ccip) {
            return this.dimension == dim && this.chunkCoords.equals((Object)ccip);
        }
    }
}

