/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.WorldUtils;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class EnergyBridgeTracker {
    private static final Set<BlockPosEU> BRIDGE_LOCATIONS = new HashSet<BlockPosEU>();
    private static final Int2IntOpenHashMap BRIDGE_COUNTS = new Int2IntOpenHashMap();
    private static int bridgeCountInEndDimensions;
    private static boolean dirty;

    public static void addBridgeLocation(World world, BlockPos pos) {
        EnergyBridgeTracker.addBridgeLocation(new BlockPosEU(pos, world.field_73011_w.getDimension(), EnumFacing.UP), true);
        if (WorldUtils.isEndDimension(world)) {
            ++bridgeCountInEndDimensions;
        }
    }

    public static void removeBridgeLocation(World world, BlockPos posIn) {
        int dimension = world.field_73011_w.getDimension();
        BlockPosEU pos = new BlockPosEU(posIn, dimension, EnumFacing.UP);
        if (BRIDGE_LOCATIONS.remove(pos)) {
            if (BRIDGE_COUNTS.get(dimension) <= 1) {
                BRIDGE_COUNTS.remove(dimension);
            } else {
                BRIDGE_COUNTS.addTo(dimension, -1);
            }
            if (WorldUtils.isEndDimension(world)) {
                --bridgeCountInEndDimensions;
            }
        }
        dirty = true;
    }

    public static boolean dimensionHasEnergyBridge(int dimension) {
        return (Integer)BRIDGE_COUNTS.getOrDefault((Object)dimension, (Object)0) > 0;
    }

    public static boolean endHasEnergyBridges() {
        return bridgeCountInEndDimensions > 0;
    }

    private static void addBridgeLocation(BlockPosEU pos, boolean markDirty) {
        if (!BRIDGE_LOCATIONS.contains(pos)) {
            BRIDGE_LOCATIONS.add(pos);
            BRIDGE_COUNTS.addTo(pos.getDimension(), 1);
        }
        if (markDirty) {
            dirty = true;
        }
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("EnergyBridges", 9)) {
            return;
        }
        NBTTagList tagList = nbt.func_150295_c("EnergyBridges", 10);
        int count = tagList.func_74745_c();
        boolean hasEndBridgeCount = nbt.func_150297_b("BridgeCountInEnd", 3);
        bridgeCountInEndDimensions = nbt.func_74762_e("BridgeCountInEnd");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (!tag.func_150297_b("Dim", 3) || !tag.func_150297_b("posX", 3) || !tag.func_150297_b("posY", 3) || !tag.func_150297_b("posZ", 3)) continue;
            int dim = tag.func_74762_e("Dim");
            EnergyBridgeTracker.addBridgeLocation(new BlockPosEU(tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ"), dim, EnumFacing.UP), false);
            if (hasEndBridgeCount || dim != 1) continue;
            ++bridgeCountInEndDimensions;
        }
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (!BRIDGE_LOCATIONS.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (BlockPosEU pos : BRIDGE_LOCATIONS) {
                if (pos == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Dim", pos.getDimension());
                tag.func_74768_a("posX", pos.getX());
                tag.func_74768_a("posY", pos.getY());
                tag.func_74768_a("posZ", pos.getZ());
                tagList.func_74742_a((NBTBase)tag);
            }
            if (tagList.func_74745_c() > 0) {
                nbt.func_74782_a("EnergyBridges", (NBTBase)tagList);
            }
            nbt.func_74768_a("BridgeCountInEnd", bridgeCountInEndDimensions);
        }
        return nbt;
    }

    public static void readFromDisk() {
        BRIDGE_LOCATIONS.clear();
        BRIDGE_COUNTS.clear();
        bridgeCountInEndDimensions = 0;
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            File file = new File(new File(saveDir, "enderutilities"), "energybridges.dat");
            if (file.exists() && file.isFile()) {
                FileInputStream is = new FileInputStream(file);
                EnergyBridgeTracker.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)is));
                is.close();
            }
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to read Energy Bridge data from file!", (Throwable)e);
        }
    }

    public static void writeToDisk() {
        if (!dirty) {
            return;
        }
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            if (!(saveDir = new File(saveDir, "enderutilities")).exists() && !saveDir.mkdirs()) {
                EnderUtilities.logger.warn("Failed to create the save directory '" + saveDir + "'");
                return;
            }
            File fileTmp = new File(saveDir, "energybridges.dat.tmp");
            File fileReal = new File(saveDir, "energybridges.dat");
            FileOutputStream os = new FileOutputStream(fileTmp);
            CompressedStreamTools.func_74799_a((NBTTagCompound)EnergyBridgeTracker.writeToNBT(new NBTTagCompound()), (OutputStream)os);
            os.close();
            if (fileReal.exists()) {
                fileReal.delete();
            }
            fileTmp.renameTo(fileReal);
            dirty = false;
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to write Energy Bridge data to file!", (Throwable)e);
        }
    }

    static {
        dirty = false;
    }
}

