/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.chunk;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.client.Client;
import mods.betterfoliage.client.chunk.ChunkOverlayData;
import mods.betterfoliage.client.chunk.ChunkOverlayLayer;
import mods.betterfoliage.client.chunk.IBlockUpdateListener;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J1\u0010\u0014\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001eH\u0007J0\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lmods/betterfoliage/client/chunk/ChunkOverlayManager;", "Lmods/betterfoliage/client/chunk/IBlockUpdateListener;", "()V", "chunkData", "", "Lnet/minecraft/util/math/ChunkPos;", "Lmods/betterfoliage/client/chunk/ChunkOverlayData;", "getChunkData", "()Ljava/util/Map;", "layers", "", "Lmods/betterfoliage/client/chunk/ChunkOverlayLayer;", "getLayers", "()Ljava/util/List;", "clear", "", "T", "layer", "pos", "Lnet/minecraft/util/math/BlockPos;", "get", "world", "Lnet/minecraft/world/IBlockAccess;", "(Lmods/betterfoliage/client/chunk/ChunkOverlayLayer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Ljava/lang/Object;", "handleLoadChunk", "event", "Lnet/minecraftforge/event/world/ChunkEvent$Load;", "handleLoadWorld", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "handleUnloadChunk", "Lnet/minecraftforge/event/world/ChunkEvent$Unload;", "notifyBlockUpdate", "Lnet/minecraft/world/World;", "oldState", "Lnet/minecraft/block/state/IBlockState;", "newState", "flags", "", "BetterFoliage-MC1.12"})
public final class ChunkOverlayManager
implements IBlockUpdateListener {
    @NotNull
    private static final Map<ChunkPos, ChunkOverlayData> chunkData;
    @NotNull
    private static final List<ChunkOverlayLayer<?>> layers;
    public static final ChunkOverlayManager INSTANCE;

    @NotNull
    public final Map<ChunkPos, ChunkOverlayData> getChunkData() {
        return chunkData;
    }

    @NotNull
    public final List<ChunkOverlayLayer<?>> getLayers() {
        return layers;
    }

    @Nullable
    public final <T> T get(@NotNull ChunkOverlayLayer<T> layer, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(layer, (String)"layer");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        ChunkOverlayData chunkOverlayData = chunkData.get(new ChunkPos(pos));
        if (chunkOverlayData == null) {
            return null;
        }
        ChunkOverlayData data = chunkOverlayData;
        T t = data.get(layer, pos);
        boolean bl = false;
        boolean bl2 = false;
        T value = t;
        boolean bl3 = false;
        if (value != ChunkOverlayData.Companion.getUNCALCULATED()) {
            return value;
        }
        T newValue = layer.calculate(world, pos);
        data.set(layer, pos, newValue);
        return newValue;
    }

    public final <T> void clear(@NotNull ChunkOverlayLayer<T> layer, @NotNull BlockPos pos) {
        block0: {
            Intrinsics.checkParameterIsNotNull(layer, (String)"layer");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            ChunkOverlayData chunkOverlayData = chunkData.get(new ChunkPos(pos));
            if (chunkOverlayData == null) break block0;
            chunkOverlayData.clear(layer, pos);
        }
    }

    public void func_184376_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        if (chunkData.containsKey(new ChunkPos(pos))) {
            Iterable $this$forEach$iv = layers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkOverlayLayer layer = (ChunkOverlayLayer)element$iv;
                boolean bl = false;
                layer.onBlockUpdate((IBlockAccess)world, pos);
            }
        }
    }

    @SubscribeEvent
    public final void handleLoadWorld(@NotNull WorldEvent.Load event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getWorld() instanceof WorldClient) {
            event.getWorld().func_72954_a((IWorldEventListener)this);
        }
    }

    @SubscribeEvent
    public final void handleLoadChunk(@NotNull ChunkEvent.Load event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getWorld() instanceof WorldClient && !(event.getChunk() instanceof EmptyChunk)) {
            Chunk chunk = event.getChunk();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"event.chunk");
            ChunkPos chunkPos = chunk.func_76632_l();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunkPos, (String)"event.chunk.pos");
            chunkData.put(chunkPos, new ChunkOverlayData(layers));
        }
    }

    @SubscribeEvent
    public final void handleUnloadChunk(@NotNull ChunkEvent.Unload event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getWorld() instanceof WorldClient) {
            Chunk chunk = event.getChunk();
            Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"event.chunk");
            chunkData.remove(chunk.func_76632_l());
        }
    }

    private ChunkOverlayManager() {
    }

    static {
        ChunkOverlayManager chunkOverlayManager;
        INSTANCE = chunkOverlayManager = new ChunkOverlayManager();
        Level level = Level.INFO;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
        Client.INSTANCE.log(level, "Initializing client overlay manager");
        MinecraftForge.EVENT_BUS.register((Object)chunkOverlayManager);
        boolean bl = false;
        chunkData = new LinkedHashMap();
        bl = false;
        layers = new ArrayList();
    }

    @Override
    public void func_184375_a(@Nullable EntityPlayer player, @NotNull SoundEvent soundIn, @NotNull SoundCategory category, double x, double y, double z, float volume, float pitch) {
        Intrinsics.checkParameterIsNotNull((Object)soundIn, (String)"soundIn");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        IBlockUpdateListener.DefaultImpls.playSoundToAllNearExcept(this, player, soundIn, category, x, y, z, volume, pitch);
    }

    @Override
    public void func_72703_a(@NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        IBlockUpdateListener.DefaultImpls.onEntityAdded(this, entityIn);
    }

    @Override
    public void func_180440_a(int soundID, @NotNull BlockPos pos, int data) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockUpdateListener.DefaultImpls.broadcastSound(this, soundID, pos, data);
    }

    @Override
    public void func_180439_a(@Nullable EntityPlayer player, int type, @NotNull BlockPos blockPosIn, int data) {
        Intrinsics.checkParameterIsNotNull((Object)blockPosIn, (String)"blockPosIn");
        IBlockUpdateListener.DefaultImpls.playEvent(this, player, type, blockPosIn, data);
    }

    @Override
    public void func_72709_b(@NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        IBlockUpdateListener.DefaultImpls.onEntityRemoved(this, entityIn);
    }

    @Override
    public void func_174959_b(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockUpdateListener.DefaultImpls.notifyLightSet(this, pos);
    }

    @Override
    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        IBlockUpdateListener.DefaultImpls.spawnParticle((IBlockUpdateListener)this, particleID, ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    @Override
    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        IBlockUpdateListener.DefaultImpls.spawnParticle((IBlockUpdateListener)this, id, ignoreRange, minimiseParticleLevel, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
    }

    @Override
    public void func_184377_a(@NotNull SoundEvent soundIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)soundIn, (String)"soundIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockUpdateListener.DefaultImpls.playRecord(this, soundIn, pos);
    }

    @Override
    public void func_180441_b(int breakerId, @NotNull BlockPos pos, int progress) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockUpdateListener.DefaultImpls.sendBlockBreakProgress(this, breakerId, pos, progress);
    }

    @Override
    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        IBlockUpdateListener.DefaultImpls.markBlockRangeForRenderUpdate(this, x1, y1, z1, x2, y2, z2);
    }
}

