/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.lib.fluid.Tank;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SingleUseTank
extends Tank {
    private static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private FluidStack acceptedFluid;

    public SingleUseTank(@Nonnull String name, int capacity, TileEntity tile) {
        super(name, capacity, tile);
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (doFill && this.acceptedFluid == null) {
            this.acceptedFluid = resource.copy();
            this.acceptedFluid.amount = 1;
        }
        if (this.acceptedFluid == null || this.acceptedFluid.isFluidEqual(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public void reset() {
        this.acceptedFluid = null;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = fluid == null ? null : new FluidStack(fluid, 1);
    }

    public void setAcceptedFluid(FluidStack fluid) {
        this.acceptedFluid = fluid == null ? null : new FluidStack(fluid, 1);
    }

    public FluidStack getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void writeTankToNBT(NBTTagCompound nbt) {
        super.writeTankToNBT(nbt);
        if (this.acceptedFluid != null) {
            nbt.func_74782_a(NBT_ACCEPTED_FLUID, (NBTBase)this.acceptedFluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readTankFromNBT(NBTTagCompound nbt) {
        super.readTankFromNBT(nbt);
        if (nbt.func_150297_b(NBT_ACCEPTED_FLUID, 8)) {
            this.setAcceptedFluid(FluidRegistry.getFluid((String)nbt.func_74779_i(NBT_ACCEPTED_FLUID)));
        } else {
            this.acceptedFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(NBT_ACCEPTED_FLUID));
        }
    }
}

