/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.lib.nbt.NbtSquisher;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class ZipFileHelper {
    private final Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private final Map<String, String> comments = new HashMap<String, String>();

    public ZipFileHelper() {
    }

    public ZipFileHelper(ZipInputStream zis) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            this.comments.put(name, entry.getComment());
            this.entries.put(name, IOUtils.toByteArray((InputStream)zis));
        }
    }

    public void write(ZipOutputStream zos) throws IOException {
        for (String key : this.entries.keySet()) {
            this.writeEntry(zos, key);
        }
    }

    private void writeEntry(ZipOutputStream zos, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setComment(this.comments.get(entryName));
        zos.putNextEntry(entry);
        zos.write(this.entries.get(entryName));
        zos.closeEntry();
    }

    public ImmutableSet<String> getKeys() {
        return ImmutableSet.copyOf(this.entries.keySet());
    }

    public void addNbtEntry(String name, String comment, NBTTagCompound nbt, int type) {
        this.comments.put(name, comment);
        this.entries.put(name, NbtSquisher.squish(nbt, type));
    }

    public void addTextEntry(String name, String comment, String text) {
        this.comments.put(name, comment);
        this.entries.put(name, text.getBytes(StandardCharsets.UTF_8));
    }

    public NBTTagCompound getNbtEntry(String name) throws IOException {
        byte[] bytes = this.entries.get(name);
        if (bytes == null) {
            throw new IOException("No bytes for entry " + name);
        }
        return NbtSquisher.expand(bytes);
    }

    public String getTextEntry(String name) throws IOException {
        byte[] bytes = this.entries.get(name);
        if (bytes == null) {
            throw new IOException("No bytes for entry " + name);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Nullable
    public ByteArrayInputStream getInputStream(String name) {
        byte[] bytes = this.entries.get(name);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }
}

