/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.io.IOException;
import java.util.Objects;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NetworkedFluidStackCache
extends NetworkedObjectCache<FluidStack> {
    private static final int FLUID_AMOUNT = 1;

    public NetworkedFluidStackCache() {
        super(new FluidStack(FluidRegistry.WATER, 1));
    }

    @Override
    protected Object2IntMap<FluidStack> createObject2IntMap() {
        return new Object2IntOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<FluidStack>(){

            public int hashCode(FluidStack o) {
                if (o == null) {
                    return 0;
                }
                return Objects.hash(o.getFluid(), o.tag);
            }

            public boolean equals(FluidStack a, FluidStack b) {
                if (a == null || b == null) {
                    return a == b;
                }
                return a.getFluid() == b.getFluid() && Objects.equals(a.tag, b.tag);
            }
        });
    }

    @Override
    protected FluidStack copyOf(FluidStack object) {
        return object.copy();
    }

    @Override
    protected void writeObject(FluidStack obj, PacketBufferBC buffer) {
        Fluid f = obj.getFluid();
        buffer.func_180714_a(FluidRegistry.getFluidName((Fluid)f));
        if (obj.tag == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_150786_a(obj.tag);
        }
    }

    @Override
    protected FluidStack readObject(PacketBufferBC buffer) throws IOException {
        Fluid fluid = FluidRegistry.getFluid((String)buffer.func_150789_c(255));
        FluidStack stack = new FluidStack(fluid, 1);
        if (buffer.readBoolean()) {
            stack.tag = buffer.func_150793_b();
        }
        return stack;
    }

    @Override
    protected String getCacheName() {
        return "FluidStack";
    }
}

