/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRailDetectorBase
extends BlockRailDetector {
    private Predicate<Entity> filter;

    public BlockRailDetectorBase(Predicate<Entity> cart) {
        this.filter = cart;
        this.func_149711_c(0.7f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public static boolean isRider(Entity entity, Predicate<Entity> rider) {
        EntityMinecart cart;
        Optional riding;
        if (entity instanceof EntityMinecart && (riding = (cart = (EntityMinecart)entity).func_184188_bt().stream().findFirst()).isPresent()) {
            return rider.apply(riding.orElse(null));
        }
        return false;
    }

    protected <T extends EntityMinecart> List<T> func_176571_a(World worldIn, BlockPos pos, Class<T> clazz, Predicate<Entity> ... filters) {
        AxisAlignedBB axisalignedbb = this.getDectectionBox(pos);
        HashSet p = Sets.newHashSet((Object[])filters);
        p.add(this.filter);
        return worldIn.func_175647_a(clazz, axisalignedbb, entity -> p.stream().anyMatch(f -> f.apply(entity)));
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + 0.2f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.2f), (double)((float)(pos.func_177958_n() + 1) - 0.2f), (double)((float)(pos.func_177956_o() + 1) - 0.2f), (double)((float)(pos.func_177952_p() + 1) - 0.2f));
    }
}

