/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockGearbox;
import betterwithmods.common.blocks.tile.TileBasic;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileGearbox
extends TileBasic
implements IMechanicalPower {
    protected int power;
    protected int maxPower;
    protected int tick;
    protected int unchanged;

    public TileGearbox() {
    }

    public TileGearbox(int maxPower) {
        this.maxPower = maxPower;
    }

    public void onChanged() {
        ++this.tick;
        if (this.tick < 20) {
            return;
        }
        this.tick = 0;
        if (BWMAPI.IMPLEMENTATION.isRedstonePowered(this.field_145850_b, this.field_174879_c)) {
            this.setPower(0);
            this.func_70296_d();
            return;
        }
        int power = this.getMechanicalInput(this.getFacing());
        if (power != this.power) {
            this.setPower(power);
            this.unchanged = 0;
        } else {
            ++this.unchanged;
        }
        if (this.isOverpowered() && this.unchanged > 30) {
            this.getBlock().overpower(this.field_145850_b, this.field_174879_c);
        }
        this.func_70296_d();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing != this.getFacing() && BWMAPI.IMPLEMENTATION.isAxle((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d())) {
            return Math.min(this.power, this.maxPower);
        }
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        BlockPos pos = this.getBlockPos().func_177972_a(facing);
        if (BWMAPI.IMPLEMENTATION.getMechanicalPower(this.field_145850_b, pos, facing.func_176734_d()) != null && !(BWMAPI.IMPLEMENTATION.getMechanicalPower(this.field_145850_b, pos, facing.func_176734_d()) instanceof TileGearbox)) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, pos, facing.func_176734_d());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return this.maxPower;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.power = tag.func_74762_e("power");
        this.maxPower = tag.func_74762_e("maxPower");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        tag.func_74768_a("power", this.power);
        tag.func_74768_a("maxPower", this.maxPower);
        return t;
    }

    @Override
    public BlockGearbox getBlock() {
        return (BlockGearbox)this.func_145838_q();
    }

    public EnumFacing getFacing() {
        return this.getBlock().getFacing((IBlockAccess)this.field_145850_b, this.field_174879_c);
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getBlock().setActive(this.field_145850_b, this.field_174879_c, this.power > 0);
    }

    public String toString() {
        return String.format("%s", this.power);
    }

    @Override
    public World getBlockWorld() {
        return super.func_145831_w();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.func_174877_v();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isOverpowered() {
        return this.power > this.getMaximumInput(this.getFacing());
    }
}

