/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemEnderSpectacles;
import betterwithmods.common.potion.BWPotion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class PotionEventHandler {
    @SubscribeEvent
    public static void onEndermanLook(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityEnderman && target instanceof EntityPlayer && target.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemEnderSpectacles) {
            ((EntityEnderman)living).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onRenderFireOverlay(RenderBlockOverlayEvent e) {
        if (e.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && e.getPlayer().func_130014_f_().func_180495_p(e.getBlockPos()).func_177230_c() == BWMBlocks.STOKED_FLAME) {
            PotionEventHandler.renderFireInFirstPerson();
            e.setCanceled(true);
        }
    }

    private static void renderFireInFirstPerson() {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179094_E();
            TextureAtlasSprite textureatlassprite = mc.func_147117_R().getTextureExtry("betterwithmods:blocks/stoked_fire_layer_0");
            if (textureatlassprite == null) {
                textureatlassprite = mc.func_147117_R().func_174944_f();
            }
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            float f1 = textureatlassprite.func_94209_e();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94206_g();
            float f4 = textureatlassprite.func_94210_h();
            GlStateManager.func_179109_b((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)f2, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)f1, (double)f4).func_181675_d();
            vertexbuffer.func_181662_b(0.5, 0.5, -0.5).func_187315_a((double)f1, (double)f3).func_181675_d();
            vertexbuffer.func_181662_b(-0.5, 0.5, -0.5).func_187315_a((double)f2, (double)f3).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && !event.isSilkTouching() && event.getHarvester().func_70644_a(BWRegistry.POTION_FORTUNE)) {
            PotionEffect effect = event.getHarvester().func_70660_b(BWRegistry.POTION_FORTUNE);
            int level = effect.func_76458_c() + 1;
            if (event.getFortuneLevel() < level) {
                event.getDrops().clear();
                event.getDrops().addAll(event.getState().func_177230_c().getDrops((IBlockAccess)event.getWorld(), event.getPos(), event.getState(), level));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LootingLevelEvent event) {
        PotionEffect effect;
        if (event.getEntityLiving() != null && (effect = event.getEntityLiving().func_70660_b(BWRegistry.POTION_LOOTING)) != null) {
            int level = effect.func_76458_c() + 1;
            if (event.getLootingLevel() < level) {
                event.setLootingLevel(level);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = e.player;
        for (PotionEffect potion : player.func_70651_bq()) {
            if (!(potion.func_188419_a() instanceof BWPotion)) continue;
            ((BWPotion)potion.func_188419_a()).tick((EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public static void saveSoup(LivingEntityUseItemEvent.Finish event) {
        ItemStack item = event.getItem();
        if (item.func_77973_b() instanceof ItemSoup) {
            ItemStack result = event.getResultStack();
            ItemStack copy = item.func_77946_l();
            copy.func_190918_g(1);
            event.setResultStack(copy);
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
            }
        }
    }
}

