/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.hardcore.beacons.BeaconEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PotionBeaconEffect
extends BeaconEffect {
    private Map<PotionEffect, Amplification> potionEffects = new HashMap<PotionEffect, Amplification>();
    private Predicate<EntityLivingBase> canApply = T -> true;

    public PotionBeaconEffect(String name, BlockIngredient structureBlock, Class<? extends EntityLivingBase> validEntityType) {
        super(name, structureBlock, validEntityType);
    }

    public PotionBeaconEffect addPotionEffect(Potion potion, int duration, Amplification amplification) {
        this.potionEffects.put(new PotionEffect(potion, duration, 1), amplification);
        return this;
    }

    public PotionBeaconEffect setCanApply(Predicate<EntityLivingBase> canApply) {
        this.canApply = canApply;
        return this;
    }

    @Override
    public void onBeaconCreate(@Nonnull World world, @Nonnull BlockPos pos, int beaconLevel) {
    }

    @Override
    public void apply(NonNullList<EntityLivingBase> entitiesInRange, @Nonnull World world, @Nonnull BlockPos pos, int beaconLevel) {
        ArrayList amplifiedPotionEffects = new ArrayList();
        this.potionEffects.forEach((potionEffect, amplification) -> amplifiedPotionEffects.add(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), amplification.getForLevel(beaconLevel))));
        for (EntityLivingBase entity : entitiesInRange) {
            for (PotionEffect potionEffect2 : amplifiedPotionEffects) {
                if (!entity.func_70687_e(potionEffect2) || !this.canApply.test(entity)) continue;
                entity.func_70690_d(potionEffect2);
            }
        }
    }

    @Override
    public boolean onPlayerInteracted(World world, BlockPos pos, int level, EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    @Override
    public void onBeaconBreak(World world, BlockPos pos, int level) {
    }

    protected static enum Amplification {
        ZERO(beaconLevel -> 0),
        NONE(beaconLevel -> 1),
        LEVEL(beaconLevel -> beaconLevel),
        LEVEL_REDUCED(beaconLevel -> beaconLevel - 1);

        private Function<Integer, Integer> amplifier;

        private Amplification(Function<Integer, Integer> amplifier) {
            this.amplifier = amplifier;
        }

        public int getForLevel(int beaconLevel) {
            return this.amplifier.apply(beaconLevel);
        }
    }
}

