/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMItems;
import betterwithmods.common.entity.EntityIngredientRelationRegistry;
import betterwithmods.common.entity.ai.eat.EntityAIAnimalEat;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.creatures.chicken.HCChickens;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;

public class EasyBreeding
extends Feature {
    public static EntityIngredientRelationRegistry REGISTRY = new EntityIngredientRelationRegistry();

    @Override
    public String getFeatureDescription() {
        return "Animals will pick up breeding items off of the ground as necessary, some animals will also breed with more items.";
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        REGISTRY.addBreedingEntry(new HCChickens.LayerIngredientRelation());
        REGISTRY.addPredicateEntry(new ResourceLocation("betterwithmods", "chicken"), e -> e instanceof EntityChicken).addIngredient((Ingredient)new OreIngredient("seed"));
        REGISTRY.addPredicateEntry(new ResourceLocation("betterwithmods", "pig"), e -> e instanceof EntityPig).addIngredient(Ingredient.func_193368_a((Item[])new Item[]{BWMItems.CHOCOLATE, Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151015_O, BWMItems.KIBBLE}));
        REGISTRY.addPredicateEntry(new ResourceLocation("betterwithmods", "herd"), e -> e instanceof EntitySheep || e instanceof EntityCow).addIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151015_O)}));
    }

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent event) {
        EntityAnimal animal;
        Ingredient ingredient;
        EntityLivingBase entity;
        if (event.getEntity() instanceof EntityLivingBase && (entity = (EntityLivingBase)event.getEntity()) instanceof EntityAnimal && (ingredient = REGISTRY.findIngredient((Entity)(animal = (EntityAnimal)entity))) != null) {
            animal.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAnimalEat(animal, ingredient, 5.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        EntityAnimal animal;
        Ingredient ingredient;
        EntityLivingBase entity;
        if (event.isCanceled()) {
            return;
        }
        if (event.getTarget() instanceof EntityLivingBase && (entity = (EntityLivingBase)event.getTarget()) instanceof EntityAnimal && (ingredient = REGISTRY.findIngredient((Entity)(animal = (EntityAnimal)entity))) != null) {
            EnumHand hand;
            EntityPlayer player;
            ItemStack itemstack;
            if (animal.func_70631_g_()) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.FAIL);
            }
            if ((ingredient.apply(itemstack = (player = event.getEntityPlayer()).func_184586_b(hand = event.getHand())) || animal.func_70877_b(itemstack)) && animal.func_70874_b() == 0 && !animal.func_70880_s()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                animal.func_146082_f(player);
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"easybreeding", "animania"};
    }
}

