/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.noworldgen5you;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.noworldgen5you.world.gen.MapGenScatteredFeaturesEmpty;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class WorldgenConfig {
    private static Configuration config;
    public static final Map<String, Boolean> settings;

    public static Configuration initConfig(File file) {
        config = new Configuration(file);
        config.setCategoryComment("map_structures", "Allows for various types of map generators to be disabled.");
        for (InitMapGenEvent.EventType eventType : InitMapGenEvent.EventType.values()) {
            if (eventType == InitMapGenEvent.EventType.CUSTOM) continue;
            WorldgenConfig.isStructureDisabled(eventType.name().toLowerCase());
        }
        config.setCategoryComment("scattered_structures", "This category requires the scattered map generator from the map_structures category to be disabled.");
        for (MapGenScatteredFeaturesEmpty.Type type : MapGenScatteredFeaturesEmpty.Type.values()) {
            WorldgenConfig.isScateredStructureDisabled(type.name().toLowerCase());
        }
        config.setCategoryComment("map_populates", "Allows for various types of chunk populators to be disabled.");
        for (PopulateChunkEvent.Populate.EventType eventType : PopulateChunkEvent.Populate.EventType.values()) {
            if (eventType == PopulateChunkEvent.Populate.EventType.CUSTOM) continue;
            WorldgenConfig.isPopulateDisabled(eventType.name().toLowerCase());
        }
        WorldgenConfig.syncConfigData();
        return config;
    }

    public static void syncConfigData() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isStructureDisabled(String type) {
        boolean result = config.getBoolean("disable_" + type, "map_structures", false, "Should " + type + " generation be disabled?");
        return result;
    }

    public static boolean isScateredStructureDisabled(String type) {
        boolean result = config.getBoolean("disable_" + type, "scattered_structures", false, "Should " + type + " generation be disabled?");
        return result;
    }

    public static boolean isPopulateDisabled(String type) {
        boolean result = config.getBoolean("disable_" + type, "map_populates", false, "Should " + type + " generation be disabled?");
        return result;
    }

    static {
        settings = new HashMap<String, Boolean>();
    }
}

