/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.event.PreRenderShadersEvent;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.config.BetweenlandsConfig;

public class ShaderHandler {
    public static final ShaderHandler INSTANCE = new ShaderHandler();
    private boolean cancelTransparentOverlays = false;

    @SubscribeEvent
    public void onPreRenderShaders(PreRenderShadersEvent event) {
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            ShaderHelper.INSTANCE.renderShaders(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPreRenderWorld(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean canUseInWorld = true;
            if (BetweenlandsConfig.RENDERING.dimensionShaderOnly) {
                boolean bl = canUseInWorld = mc.field_71441_e != null && mc.field_71441_e.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId;
            }
            if (ShaderHelper.INSTANCE.isShaderSupported() && BetweenlandsConfig.RENDERING.useShader && canUseInWorld) {
                ShaderHelper.INSTANCE.initShaders();
                Framebuffer framebuffer = mc.func_147110_a();
                if (!mc.field_71474_y.field_151448_g) {
                    mc.field_71474_y.field_151448_g = true;
                    framebuffer.func_147613_a(mc.field_71443_c, mc.field_71440_d);
                }
                if (ShaderHelper.INSTANCE.isHDRActive()) {
                    int colorFormat;
                    int n = ShaderHelper.INSTANCE.isFloatBufferSupported() ? 34842 : (colorFormat = ShaderHelper.INSTANCE.isARBFloatBufferSupported() ? 34843 : -1);
                    if (colorFormat != -1) {
                        GlStateManager.func_179144_i((int)framebuffer.field_147617_g);
                        GlStateManager.func_187419_a((int)3553, (int)0, (int)colorFormat, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)0, (int)6408, (int)5126, (IntBuffer)null);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorldLastHighest(RenderWorldLastEvent event) {
        if (BetweenlandsConfig.RENDERING.shaderPriority == 2) {
            this.updateShaders(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderWorldLastNormal(RenderWorldLastEvent event) {
        if (BetweenlandsConfig.RENDERING.shaderPriority == 1) {
            this.updateShaders(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLastLowest(RenderWorldLastEvent event) {
        if (BetweenlandsConfig.RENDERING.shaderPriority == 0) {
            this.updateShaders(event);
        }
    }

    private void updateShaders(RenderWorldLastEvent event) {
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            GL11.glMatrixMode((int)5888);
            GlStateManager.func_179094_E();
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.cancelTransparentOverlays = true;
            Minecraft.func_71410_x().field_71460_t.func_78476_b(event.getPartialTicks(), MinecraftForgeClient.getRenderPass());
            Minecraft.func_71410_x().field_71460_t.func_78479_a(event.getPartialTicks(), MinecraftForgeClient.getRenderPass());
            this.cancelTransparentOverlays = false;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            ShaderHelper.INSTANCE.updateShaders(event.getPartialTicks());
            GL11.glMatrixMode((int)5888);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (this.cancelTransparentOverlays && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPostRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && ShaderHelper.INSTANCE.getWorldShader() != null) {
            ShaderHelper.INSTANCE.getWorldShader().clearLights();
            ShaderHelper.INSTANCE.getWorldShader().clearGroundFogVolumes();
        }
    }
}

