/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.gallery.GalleryEntry;
import thebetweenlands.client.handler.gallery.GalleryManager;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.EntityGalleryFrame;

@SideOnly(value=Side.CLIENT)
public class RenderGalleryFrame
extends Render<EntityGalleryFrame> {
    public static final ResourceLocation GALLERY_FRAME_EMPTY_BACKGROUND = new ResourceLocation("thebetweenlands", "textures/entity/gallery_frame_empty_background.png");

    public RenderGalleryFrame(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityGalleryFrame entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GalleryEntry entry = GalleryManager.INSTANCE.getEntries().get(entity.getUrl());
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        float relWidth = 1.0f;
        float relHeight = 1.0f;
        if (entry != null) {
            int maxDim = Math.max(entry.getWidth(), entry.getHeight());
            relWidth = 1.0f - (float)(maxDim - entry.getWidth()) / (float)maxDim;
            relHeight = 1.0f - (float)(maxDim - entry.getHeight()) / (float)maxDim;
        }
        float width = relWidth * (float)entity.func_82329_d() / 16.0f / 2.0f;
        float height = relHeight * (float)entity.func_82330_g() / 16.0f / 2.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        buffer.func_181662_b((double)width, (double)(-height), 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)(-height), 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (entry == null && !BetweenlandsConfig.GENERAL.onlineGallery) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.435, (double)0.0, (double)-0.03f);
            GlStateManager.func_179152_a((float)-0.0078125f, (float)-0.0078125f, (float)0.0078125f);
            GlStateManager.func_179140_f();
            String[] notFoundLines = I18n.func_135052_a((String)"gui.gallery.not_found", (Object[])new Object[0]).split("\\\\n");
            int yOff = -6 * notFoundLines.length;
            for (int i = 0; i < notFoundLines.length; ++i) {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(notFoundLines[i], 0, yOff, -1);
                yOff += 12;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityGalleryFrame entity) {
        GalleryEntry entry = GalleryManager.INSTANCE.getEntries().get(entity.getUrl());
        ResourceLocation pictureLocation = entry != null ? entry.loadTextureAndGetLocation(GALLERY_FRAME_EMPTY_BACKGROUND) : GALLERY_FRAME_EMPTY_BACKGROUND;
        return pictureLocation;
    }
}

