/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.entity.RenderWallFace;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelWallHole;
import thebetweenlands.common.entity.mobs.EntityWallFace;
import thebetweenlands.util.Stencil;

@SideOnly(value=Side.CLIENT)
public abstract class RenderWallHole<T extends EntityWallFace>
extends RenderWallFace<T> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
    private static final ResourceLocation WALL_TEXTURE_OVERLAY = new ResourceLocation("thebetweenlands", "textures/entity/wall_hole_overlay.png");
    private static final ResourceLocation WALL_TEXTURE = new ResourceLocation("thebetweenlands", "textures/blocks/mud_bricks.png");
    private final ResourceLocation modelTexture;
    private final ModelWallHole modelBlockTextured;
    private final ModelWallHole modelNormal;
    private final ModelBase model;
    private boolean renderWall = false;
    private int renderPass = 0;
    private float partialTicks;

    public RenderWallHole(RenderManager renderManager, ModelBase model, ResourceLocation modelTexture) {
        super(renderManager, model, 0.0f);
        this.modelTexture = modelTexture;
        this.model = model;
        this.modelBlockTextured = new ModelWallHole(true);
        this.modelNormal = new ModelWallHole(false);
        this.func_177094_a(new LayerOverlay<T>((RenderLivingBase)this, WALL_TEXTURE_OVERLAY){

            @Override
            protected ModelBase[] getModels(T entity) {
                return new ModelBase[]{RenderWallHole.this.modelNormal};
            }
        });
        this.func_177094_a(new LayerOverlay<T>((RenderLivingBase)this){

            @Override
            protected ModelBase[] getModels(T entity) {
                return new ModelBase[]{RenderWallHole.this.modelNormal};
            }

            @Override
            protected ResourceLocation getTexture(T entity, int index) {
                int damage = MathHelper.func_76123_f((float)((1.0f - entity.func_110143_aJ() / entity.func_110138_aP()) * 10.0f));
                if (damage > 0 && damage <= 10) {
                    return DESTROY_STAGES[damage - 1];
                }
                return null;
            }

            @Override
            protected void renderOverlay(T entity, ModelBase model, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                this.preRenderDamagedBlocks();
                super.renderOverlay(entity, model, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                this.postRenderDamagedBlocks();
            }

            private void preRenderDamagedBlocks() {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179096_D();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)0.0f);
                GlStateManager.func_179128_n((int)5888);
            }

            private void postRenderDamagedBlocks() {
                GlStateManager.func_179118_c();
                GlStateManager.func_179141_d();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        });
    }

    @Override
    protected void preRenderCallback(T entity, float partialTickTime) {
        super.preRenderCallback(entity, partialTickTime);
        GlStateManager.func_179137_b((double)0.0, (double)0.55, (double)0.3);
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.partialTicks = partialTicks;
        Framebuffer fbo = Minecraft.func_71410_x().func_147110_a();
        try (Stencil stencil = Stencil.reserve(fbo);){
            if (stencil.valid()) {
                GL11.glEnable((int)2960);
                stencil.clear(false);
                stencil.func(519, true);
                stencil.op(7681, 7680, 7681);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.5f);
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179090_x();
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-5.0f, (float)-5.0f);
                this.modelBlockTextured.frontPiece1.field_78806_j = false;
                this.modelBlockTextured.window.field_78806_j = true;
                this.modelBlockTextured.setWindowZOffsetPercent(-0.001f);
                this.renderPass = 0;
                super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
                this.modelBlockTextured.frontPiece1.field_78806_j = true;
                this.modelBlockTextured.window.field_78806_j = false;
                GlStateManager.func_179113_r();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179098_w();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                stencil.func(514, true);
                stencil.op(7680);
            }
            GlStateManager.func_179143_c((int)518);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.renderPass = 1;
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179143_c((int)515);
            GL11.glDisable((int)2960);
        }
        this.renderPass = 2;
        this.modelBlockTextured.window.field_78806_j = true;
        this.modelBlockTextured.setWindowZOffsetPercent(this.getHoleDepthPercent(entity, partialTicks));
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        this.modelBlockTextured.window.field_78806_j = false;
    }

    @Nullable
    protected abstract TextureAtlasSprite getWallSprite(T var1);

    protected abstract float getHoleDepthPercent(T var1, float var2);

    protected abstract float getMainModelVisibilityPercent(T var1, float var2);

    protected void renderModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.field_77045_g = this.modelBlockTextured;
        this.renderWall = true;
        TextureAtlasSprite wallSprite = this.getWallSprite(entity);
        if (wallSprite != null) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)wallSprite.func_94209_e(), (float)wallSprite.func_94206_g(), (float)0.0f);
            GlStateManager.func_179152_a((float)(wallSprite.func_94212_f() - wallSprite.func_94209_e()), (float)(wallSprite.func_94210_h() - wallSprite.func_94206_g()), (float)1.0f);
            GlStateManager.func_179128_n((int)5888);
        }
        this.renderEntityModel(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, this.partialTicks);
        if (wallSprite != null) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        this.field_77045_g = this.model;
        this.renderWall = false;
        if (this.renderPass == 2 && this.getMainModelVisibilityPercent(entity, this.partialTicks) > 0.001f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)-0.55, (double)-0.3);
            this.applyDeathAndEasterEggRotations(entity);
            this.renderEntityModel(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, this.partialTicks);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderEntityModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float partialTicks) {
        super.func_77036_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
    }

    protected void applyDeathAndEasterEggRotations(T entity) {
        float yOffset = 1.1f;
        GlStateManager.func_179109_b((float)0.0f, (float)yOffset, (float)0.0f);
        if (((EntityWallFace)entity).field_70725_aQ > 0) {
            float deathPercent = ((float)((EntityWallFace)entity).field_70725_aQ + this.partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathPercent = MathHelper.func_76129_c((float)deathPercent)) > 1.0f) {
                deathPercent = 1.0f;
            }
            GlStateManager.func_179114_b((float)(deathPercent * this.func_77037_a((EntityLivingBase)entity) * this.getMainModelVisibilityPercent(entity, this.partialTicks)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(((EntityWallFace)entity).field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-yOffset), (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        if (this.renderWall) {
            if (this.getWallSprite(entity) != null) {
                return TextureMap.field_110575_b;
            }
            return WALL_TEXTURE;
        }
        return this.modelTexture;
    }
}

