/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import thebetweenlands.client.render.model.baked.ModelCombined;
import thebetweenlands.client.render.model.baked.ModelFromModelBase;
import thebetweenlands.client.render.model.baked.ModelRubberTapLiquid;
import thebetweenlands.client.render.model.baked.modelbase.ModelRubberTap;
import thebetweenlands.util.TexturePacker;

public class ModelRubberTapCombined
implements IModel {
    private final ModelFromModelBase tapModel;
    private final IModel combinedTapModel;
    private final int height;
    private final ResourceLocation particleTexture;
    private final ResourceLocation fluidTexture;

    public ModelRubberTapCombined(TexturePacker packer, ResourceLocation texture, ResourceLocation particle) {
        this(packer, texture, particle, null, 0);
    }

    public ModelRubberTapCombined(TexturePacker packer, ResourceLocation texture, ResourceLocation particleTexture, ResourceLocation fluidTexture, int height) {
        this.tapModel = new ModelFromModelBase.Builder(new ModelRubberTap(), texture, 128, 128).particleTexture(particleTexture).packer(packer).doubleFace(false).build();
        this.combinedTapModel = new ModelCombined(this.tapModel, new ModelRubberTapLiquid(fluidTexture, height));
        this.particleTexture = particleTexture;
        this.height = height;
        this.fluidTexture = fluidTexture;
    }

    protected ModelRubberTapCombined(ModelFromModelBase parent, ResourceLocation particleTexture, ResourceLocation fluidTexture, int height) {
        this.tapModel = new ModelFromModelBase(parent, particleTexture, 128, 128, null, parent.doubleFace, parent.ambientOcclusion);
        this.combinedTapModel = new ModelCombined(this.tapModel, new ModelRubberTapLiquid(fluidTexture, height));
        this.particleTexture = particleTexture;
        this.height = height;
        this.fluidTexture = fluidTexture;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.combinedTapModel.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.combinedTapModel.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.combinedTapModel.bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.combinedTapModel.getDefaultState();
    }

    public ModelRubberTapCombined process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        ResourceLocation fluidTexture = this.fluidTexture;
        if (customData.containsKey((Object)"fluid_texture")) {
            fluidTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"fluid_texture")), (String)"fluid_texture"));
        }
        if (fluidTexture == null) {
            fluidTexture = TextureMap.field_174945_f;
        }
        int height = this.height;
        if (customData.containsKey((Object)"fluid_height")) {
            String fluidHeightJsonStr = (String)customData.get((Object)"fluid_height");
            height = JsonUtils.func_151215_f((JsonElement)parser.parse(fluidHeightJsonStr), (String)"fluid_height");
        }
        ResourceLocation particleTexture = this.particleTexture;
        if (customData.containsKey((Object)"particle_texture")) {
            String particleTextureJsonStr = (String)customData.get((Object)"particle_texture");
            particleTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse(particleTextureJsonStr), (String)"particle_texture"));
        }
        return new ModelRubberTapCombined(this.tapModel, particleTexture, fluidTexture, height);
    }
}

