/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.loader;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.loader.CustomModelManager;
import thebetweenlands.client.render.model.loader.IBakedModelDependant;
import thebetweenlands.client.render.model.loader.IFastTESRBakedModels;
import thebetweenlands.client.render.model.loader.extension.AdvancedItemLoaderExtension;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;
import thebetweenlands.client.render.model.loader.extension.LoaderExtensionException;
import thebetweenlands.client.render.model.loader.extension.ModelProcessorLoaderExtension;
import thebetweenlands.client.render.model.loader.extension.SimpleItemLoaderExtension;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;

public final class CustomModelLoader
implements ICustomModelLoader {
    private final CustomModelManager manager;
    private final List<LoaderExtension> loaderExtensions = new ArrayList<LoaderExtension>();
    public static final LoaderExtension SIMPLE_ITEM_LOADER_EXTENSION = new SimpleItemLoaderExtension();
    public static final LoaderExtension ADVANCED_ITEM_LOADER_EXTENSION = new AdvancedItemLoaderExtension();
    public static final LoaderExtension MODEL_PROCESSOR_LOADER_EXTENSION = new ModelProcessorLoaderExtension();

    CustomModelLoader(CustomModelManager manager) {
        this.manager = manager;
        this.registerExtension(SIMPLE_ITEM_LOADER_EXTENSION);
        this.registerExtension(ADVANCED_ITEM_LOADER_EXTENSION);
        this.registerExtension(MODEL_PROCESSOR_LOADER_EXTENSION);
    }

    public CustomModelLoader registerExtension(@Nonnull LoaderExtension extension) {
        Validate.notNull((Object)extension);
        this.loaderExtensions.add(extension);
        return this;
    }

    public List<LoaderExtension> getExtensions() {
        return Collections.unmodifiableList(this.loaderExtensions);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        for (LoaderExtension extension : this.loaderExtensions) {
            if (!(extension instanceof IResourceManagerReloadListener)) continue;
            ((IResourceManagerReloadListener)extension).func_110549_a(resourceManager);
        }
    }

    public boolean accepts(ResourceLocation modelLocation) {
        LoaderResult result;
        if (modelLocation.func_110623_a().contains("$") && (result = this.getLoaderResult(modelLocation)).type != LoaderType.NORMAL) {
            if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                TheBetweenlands.logger.info(String.format("Accepting model %s (full path: %s) through loader extension %s with args %s", result.actualLocation, modelLocation, result.extension.getName(), result.args));
            }
            return true;
        }
        for (Map.Entry<ResourceLocation, Function<ResourceLocation, IModel>> entry : this.manager.getRegisteredModelProviders().entrySet()) {
            String suffix;
            ResourceLocation registeredModel = entry.getKey();
            if (!registeredModel.func_110624_b().equals(modelLocation.func_110624_b()) || !modelLocation.func_110623_a().startsWith(registeredModel.func_110623_a()) || (suffix = modelLocation.func_110623_a().substring(registeredModel.func_110623_a().length())).length() != 0 && !suffix.startsWith("#")) continue;
            if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                TheBetweenlands.logger.info(String.format("Accepting model %s as %s through model registry", modelLocation, registeredModel));
            }
            return true;
        }
        return false;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        LoaderResult result;
        boolean accepted = false;
        if (modelLocation.func_110623_a().contains("$") && (result = this.getLoaderResult(modelLocation)).type == LoaderType.EXTENSION) {
            accepted = true;
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)result.actualLocation);
            LoaderExtension loaderExtension = result.extension;
            String loaderArgs = result.args;
            try {
                IModel loadedModel;
                if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                    TheBetweenlands.logger.info(String.format("Loading model %s (full path: %s) through loader extension %s with args %s", result.actualLocation, modelLocation, result.extension.getName(), result.args));
                }
                if ((loadedModel = loaderExtension.loadModel(model, result.actualLocation, loaderArgs)) != null) {
                    return loadedModel;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof LoaderExtensionException)) {
                    this.throwLoaderException(loaderExtension, ex);
                }
                throw ex;
            }
        }
        if (!accepted) {
            for (Map.Entry<ResourceLocation, Function<ResourceLocation, IModel>> entry : this.manager.getRegisteredModelProviders().entrySet()) {
                IModel model;
                String suffix;
                ResourceLocation registeredModel = entry.getKey();
                if (!registeredModel.func_110624_b().equals(modelLocation.func_110624_b()) || !modelLocation.func_110623_a().startsWith(registeredModel.func_110623_a()) || (suffix = modelLocation.func_110623_a().substring(registeredModel.func_110623_a().length())).length() != 0 && !suffix.startsWith("#")) continue;
                accepted = true;
                if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                    TheBetweenlands.logger.info(String.format("Loading model %s as %s through model registry", modelLocation, registeredModel));
                }
                if ((model = (IModel)entry.getValue().apply((Object)modelLocation)) == null) continue;
                return model;
            }
        }
        if (BetweenlandsConfig.DEBUG.debugModelLoader) {
            TheBetweenlands.logger.error("Unable to load model %s!", (Object)modelLocation);
        }
        return null;
    }

    private LoaderResult getLoaderResult(ResourceLocation modelLocation) {
        String fullModelPath = modelLocation.func_110623_a();
        String modelPath = fullModelPath.substring(0, fullModelPath.indexOf("$"));
        String suffix = fullModelPath.substring(fullModelPath.indexOf("$"));
        LoaderExtension loaderExtension = null;
        for (LoaderExtension arg : this.loaderExtensions) {
            String argPrefix = "$" + arg.getName() + "(";
            if (!suffix.startsWith(argPrefix)) continue;
            loaderExtension = arg;
            break;
        }
        String loaderArgs = null;
        if (loaderExtension != null) {
            suffix = suffix.substring(loaderExtension.getName().length() + 2);
            loaderArgs = suffix.substring(0, suffix.indexOf(")"));
            suffix = suffix.substring(loaderArgs.length() + 1);
            if (loaderArgs.length() == 0) {
                loaderArgs = null;
            }
        }
        ResourceLocation actualLocation = new ResourceLocation(modelLocation.func_110624_b(), modelPath + suffix);
        if (loaderExtension != null) {
            return new LoaderResult(actualLocation, loaderExtension, loaderArgs);
        }
        return new LoaderResult(actualLocation);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        for (TileEntitySpecialRenderer renderer : TileEntityRendererDispatcher.field_147556_a.field_147559_m.values()) {
            if (!(renderer instanceof IFastTESRBakedModels)) continue;
            Collection<ModelResourceLocation> locations = ((IFastTESRBakedModels)renderer).getModelLocations();
            for (ModelResourceLocation location : locations) {
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Failed loading model '" + location + "' for FastTESR"));
                for (ResourceLocation texture : model.getTextures()) {
                    event.getMap().func_174942_a(texture);
                }
            }
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        ArrayList<Pair> loadedModels = new ArrayList<Pair>();
        for (TileEntitySpecialRenderer renderer : TileEntityRendererDispatcher.field_147556_a.field_147559_m.values()) {
            if (!(renderer instanceof IFastTESRBakedModels)) continue;
            Collection<ModelResourceLocation> locations = ((IFastTESRBakedModels)renderer).getModelLocations();
            for (ModelResourceLocation location : locations) {
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Failed loading model '" + location + "' for FastTESR"));
                IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, loc -> Minecraft.func_71410_x().func_147117_R().func_110572_b(loc.toString()));
                modelRegistry.func_82595_a((Object)location, (Object)bakedModel);
                ((IFastTESRBakedModels)renderer).onModelBaked(location, bakedModel);
            }
        }
        for (ModelResourceLocation modelLocation : modelRegistry.func_148742_b()) {
            IBakedModel model = (IBakedModel)modelRegistry.func_82594_a((Object)modelLocation);
            if (!(model instanceof IBakedModelDependant)) continue;
            IBakedModelDependant dependant = (IBakedModelDependant)model;
            Collection<ModelResourceLocation> dependencies = dependant.getDependencies((ResourceLocation)modelLocation);
            HashMap<ModelResourceLocation, IBakedModel> loadedDependencies = new HashMap<ModelResourceLocation, IBakedModel>();
            for (ModelResourceLocation dependencyLocation : dependencies) {
                IBakedModel bakedModel = (IBakedModel)modelRegistry.func_82594_a((Object)dependencyLocation);
                if (bakedModel == null) {
                    ResourceLocation dependencyLocationNoVariants = new ResourceLocation(dependencyLocation.func_110624_b(), dependencyLocation.func_110623_a());
                    try {
                        IModel externalModel = ModelLoaderRegistry.getModel((ResourceLocation)dependencyLocationNoVariants);
                        bakedModel = externalModel.bake(dependant.getModelState(externalModel), dependant.getVertexFormat(externalModel), dependant.getTextureGetter(externalModel));
                        loadedModels.add(Pair.of((Object)dependencyLocation, (Object)bakedModel));
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to load model dependency " + dependencyLocationNoVariants + " for model " + modelLocation, ex);
                    }
                }
                loadedDependencies.put(dependencyLocation, bakedModel);
            }
            dependant.setDependencies((ResourceLocation)modelLocation, loadedDependencies);
        }
        for (Pair loadedModel : loadedModels) {
            if (loadedModel.getValue() != null) {
                if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                    TheBetweenlands.logger.info(String.format("Registering additional baked model %s", loadedModel.getKey()));
                }
                modelRegistry.func_82595_a(loadedModel.getKey(), loadedModel.getValue());
                continue;
            }
            if (!BetweenlandsConfig.DEBUG.debugModelLoader) continue;
            TheBetweenlands.logger.warn(String.format("Additional baked model %s is null!", loadedModel.getKey()));
        }
        Set keys = modelRegistry.func_148742_b();
        HashMap<ModelResourceLocation, IBakedModel> replacementMap = new HashMap<ModelResourceLocation, IBakedModel>();
        for (LoaderExtension extension : this.loaderExtensions) {
            for (ModelResourceLocation loc2 : keys) {
                try {
                    IBakedModel replacement = extension.getModelReplacement(loc2, (IBakedModel)modelRegistry.func_82594_a((Object)loc2));
                    if (replacement == null) continue;
                    replacementMap.put(loc2, replacement);
                }
                catch (Exception ex) {
                    if (!(ex instanceof LoaderExtensionException)) {
                        this.throwLoaderException(extension, ex);
                        continue;
                    }
                    throw ex;
                }
            }
        }
        this.replaceRegistryObjects(modelRegistry, replacementMap);
    }

    private void throwLoaderException(LoaderExtension extension, Throwable cause) {
        throw new LoaderExtensionException(String.format("Model loader extension %s failed loading a model", extension.getName()), cause);
    }

    private <K, T> void replaceRegistryObjects(IRegistry<K, T> registry, Map<K, T> map) {
        for (Map.Entry<K, T> e : map.entrySet()) {
            if (BetweenlandsConfig.DEBUG.debugModelLoader) {
                TheBetweenlands.logger.info(String.format("Replaced model %s", e.getKey()));
            }
            registry.func_82595_a(e.getKey(), e.getValue());
        }
    }

    private static class LoaderResult {
        private final LoaderType type;
        private final LoaderExtension extension;
        private final String args;
        private final ResourceLocation actualLocation;

        private LoaderResult(LoaderType type, LoaderExtension extension, String args, ResourceLocation location) {
            this.type = type;
            this.extension = extension;
            this.args = args;
            if (location != null && location.func_110623_a().startsWith("models/")) {
                String path = location.func_110623_a();
                path = path.substring("models/".length());
                location = new ResourceLocation(location.func_110624_b(), path);
            }
            this.actualLocation = location;
        }

        private LoaderResult(ResourceLocation location) {
            this(LoaderType.NORMAL, null, null, location);
        }

        private LoaderResult(ResourceLocation location, LoaderExtension extension, String args) {
            this(LoaderType.EXTENSION, extension, args, location);
        }
    }

    private static enum LoaderType {
        NORMAL,
        EXTENSION;

    }
}

