/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.block.property.PropertyBoolUnlisted;
import thebetweenlands.common.block.property.PropertyIntegerUnlisted;
import thebetweenlands.common.entity.mobs.EntityAshSprite;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityMudBrickAlcove;
import thebetweenlands.util.StatePropertyHelper;

public class BlockMudBrickAlcove
extends BasicBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final IUnlistedProperty<Integer> LEVEL = new PropertyIntegerUnlisted("level");
    public static final IUnlistedProperty<Boolean> TOP_COBWEB = new PropertyBoolUnlisted("top_cobweb");
    public static final IUnlistedProperty<Boolean> BOTTOM_COBWEB = new PropertyBoolUnlisted("bottom_cobweb");
    public static final IUnlistedProperty<Boolean> SMALL_CANDLE = new PropertyBoolUnlisted("small_candle");
    public static final IUnlistedProperty<Boolean> BIG_CANDLE = new PropertyBoolUnlisted("big_candle");
    public static final IProperty<Boolean> HAS_URN = PropertyBool.func_177716_a((String)"urn");

    public BlockMudBrickAlcove() {
        this(Material.field_151576_e);
    }

    public BlockMudBrickAlcove(Material material) {
        super(material);
        this.func_149713_g(255);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HAS_URN, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public static TileEntityMudBrickAlcove getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityMudBrickAlcove) {
            return (TileEntityMudBrickAlcove)tile;
        }
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING, HAS_URN}, new IUnlistedProperty[]{LEVEL, TOP_COBWEB, BOTTOM_COBWEB, SMALL_CANDLE, BIG_CANDLE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityMudBrickAlcove tile = StatePropertyHelper.getTileEntityThreadSafe(worldIn, pos, TileEntityMudBrickAlcove.class);
        if (tile != null) {
            state = state.func_177226_a(HAS_URN, (Comparable)Boolean.valueOf(tile.hasUrn));
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState extended = (IExtendedBlockState)oldState;
        TileEntityMudBrickAlcove tile = StatePropertyHelper.getTileEntityThreadSafe(worldIn, pos, TileEntityMudBrickAlcove.class);
        if (tile != null) {
            extended = extended.withProperty(TOP_COBWEB, (Object)tile.topWeb).withProperty(BOTTOM_COBWEB, (Object)tile.bottomWeb).withProperty(SMALL_CANDLE, (Object)tile.smallCandle).withProperty(BIG_CANDLE, (Object)tile.bigCandle).withProperty(LEVEL, (Object)tile.dungeonLevel);
        }
        return extended;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMudBrickAlcove();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntityMudBrickAlcove tile = BlockMudBrickAlcove.getTileEntity((IBlockAccess)world, pos);
        if (tile != null) {
            tile.setUpGreeble();
        }
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityMudBrickAlcove tile;
        if (!world.field_72995_K && (tile = BlockMudBrickAlcove.getTileEntity((IBlockAccess)world, pos)) != null && tile.hasUrn) {
            IBlockState state = world.func_180495_p(pos);
            RayTraceResult ray = this.func_185503_a(pos, player.func_174824_e(1.0f), player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_186678_a(10.0)), state.func_185900_c((IBlockAccess)world, pos));
            if (ray != null && state.func_177229_b((IProperty)FACING) == ray.field_178784_b) {
                BlockPos offsetPos = pos.func_177972_a(ray.field_178784_b);
                tile.fillInventoryWithLoot(player);
                InventoryHelper.func_180175_a((World)world, (BlockPos)offsetPos, (IInventory)tile);
                if (world.field_73012_v.nextInt(3) == 0) {
                    EntityAshSprite entity = new EntityAshSprite(world);
                    entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, offsetPos.func_177956_o(), (double)offsetPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    entity.setBoundOrigin(offsetPos);
                    world.func_72838_d((Entity)entity);
                }
                world.func_184133_a(null, pos, this.field_149762_H.func_185845_c(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)BlockRegistry.MUD_FLOWER_POT));
                tile.hasUrn = false;
                world.func_184138_a(pos, state, state, 2);
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176734_d() == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)base_state.func_177229_b((IProperty)FACING);
        return facing.func_176734_d() == side;
    }
}

