/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.network.clientbound.MessageWightVolatileParticles;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityAIWightBuffSwampHag
extends EntityAIBase {
    protected final EntityWight wight;
    protected World world;
    protected final PathNavigate navigator;
    protected int cooldown;
    protected EntitySwampHag hag = null;

    public EntityAIWightBuffSwampHag(EntityWight wight) {
        this.wight = wight;
        this.world = wight.field_70170_p;
        this.navigator = wight.func_70661_as();
        this.cooldown = 10 + this.world.field_73012_v.nextInt(20);
        this.func_75248_a(256);
    }

    public boolean func_75250_a() {
        boolean canBuff;
        boolean bl = canBuff = this.wight.func_70638_az() != null && !this.wight.func_184218_aH() && this.getTargetSwampHag() != null;
        if (canBuff) {
            if (this.cooldown <= 0 && this.world.field_73012_v.nextInt(20) == 0) {
                return true;
            }
            --this.cooldown;
        }
        return false;
    }

    public void func_75249_e() {
        this.hag = this.getTargetSwampHag();
    }

    public boolean func_75253_b() {
        return this.hag != null && this.hag.func_70089_S();
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.cooldown = 80 + this.world.field_73012_v.nextInt(60);
        if (!(this.wight.func_184218_aH() || this.hag != null && this.hag.func_70089_S())) {
            this.wight.setVolatile(false);
        }
    }

    public void func_75246_d() {
        if (this.hag != null) {
            if (!this.wight.isVolatile()) {
                this.wight.setVolatile(true);
                TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageWightVolatileParticles((Entity)this.wight), new NetworkRegistry.TargetPoint(this.wight.field_71093_bK, this.wight.field_70165_t, this.wight.field_70163_u, this.wight.field_70161_v, 32.0));
                this.world.func_184148_a(null, this.wight.field_70165_t, this.wight.field_70163_u, this.wight.field_70161_v, (SoundEvent)SoundRegistry.WIGHT_ATTACK, SoundCategory.HOSTILE, 1.6f, 1.0f);
            }
            if (!this.wight.func_184218_aH()) {
                if ((double)this.wight.func_70032_d((Entity)this.hag) < 1.75) {
                    this.wight.func_184220_m((Entity)this.hag);
                }
                this.wight.func_70671_ap().func_75651_a((Entity)this.hag, 10.0f, (float)this.wight.func_70646_bf());
                this.wight.func_70605_aq().func_75642_a(this.hag.field_70165_t, this.hag.field_70163_u, this.hag.field_70161_v, 1.0);
            }
        }
    }

    @Nullable
    protected EntitySwampHag getTargetSwampHag() {
        EntityLivingBase target = this.wight.func_70638_az();
        if (target != null) {
            double range = 16.0;
            AxisAlignedBB aabb = this.wight.func_174813_aQ().func_186662_g(range);
            EntitySwampHag closestSuitableToTarget = null;
            List nearby = this.world.func_72872_a(EntitySwampHag.class, aabb);
            for (EntitySwampHag hag : nearby) {
                if (hag.func_70638_az() != target || !hag.func_184188_bt().isEmpty() || !((double)hag.func_70032_d((Entity)this.wight) <= range) || closestSuitableToTarget != null && !(hag.func_70032_d((Entity)target) <= closestSuitableToTarget.func_70032_d((Entity)target))) continue;
                closestSuitableToTarget = hag;
            }
            return closestSuitableToTarget;
        }
        return null;
    }
}

