/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.entity.ai.WalkNodeProcessorBarrishee;
import thebetweenlands.common.entity.mobs.EntityBarrishee;

public class PathNavigateBarrishee
extends PathNavigateGround {
    protected final EntityBarrishee barrishee;
    protected int stuckCheckTicks = 0;

    public PathNavigateBarrishee(EntityBarrishee barrishee, World worldIn) {
        super((EntityLiving)barrishee, worldIn);
        this.barrishee = barrishee;
        this.func_179693_d(true);
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new WalkNodeProcessorBarrishee();
        this.field_179695_a.func_186317_a(true);
        return new PathFinder(this.field_179695_a);
    }

    protected void func_179677_a(Vec3d entityPos) {
        super.func_179677_a(entityPos);
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d target = this.field_75514_c.func_75881_a((Entity)this.barrishee, Math.min(this.field_75514_c.func_75874_d() - 1, this.field_75514_c.func_75873_e() + 0));
            Vec3d diff = target.func_178788_d(entityPos);
            boolean isFacingX = Math.abs(diff.field_72450_a) > Math.abs(diff.field_72449_c);
            int height = MathHelper.func_76141_d((float)(this.barrishee.field_70131_O + 1.0f));
            int ceilHalfWidth = MathHelper.func_76123_f((float)(this.barrishee.field_70130_N / 2.0f + 0.05f));
            Vec3d checkPos = isFacingX ? new Vec3d(entityPos.field_72450_a + Math.signum(diff.field_72450_a) * (double)ceilHalfWidth, entityPos.field_72448_b, target.field_72449_c) : new Vec3d(target.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c + Math.signum(diff.field_72449_c) * (double)ceilHalfWidth);
            boolean blocked = false;
            block0: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    AxisAlignedBB collisionBox;
                    PathNodeType nodeType;
                    BlockPos pos = new BlockPos(checkPos.field_72450_a + (double)(!isFacingX ? xzo : 0), checkPos.field_72448_b + (double)yo, checkPos.field_72449_c + (double)(isFacingX ? xzo : 0));
                    IBlockState state = this.barrishee.field_70170_p.func_180495_p(pos);
                    PathNodeType pathNodeType = nodeType = state.func_177230_c().func_176205_b((IBlockAccess)this.barrishee.field_70170_p, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    if (nodeType != PathNodeType.BLOCKED || (collisionBox = state.func_185890_d((IBlockAccess)this.barrishee.field_70170_p, pos)) == null || !collisionBox.func_186670_a(pos).func_72326_a(this.barrishee.func_174813_aQ().func_72321_a(Math.signum(diff.field_72450_a) * 0.2, 0.0, Math.signum(diff.field_72449_c) * 0.2))) continue;
                    blocked = true;
                    break block0;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > 40) {
                    this.barrishee.onPathingObstructed();
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 6, 0);
        }
    }
}

